/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.injection;

import de.quantummaid.mapmaid.debug.DebugInformation;
import de.quantummaid.mapmaid.debug.MapMaidException;
import de.quantummaid.mapmaid.debug.scaninformation.ScanInformation;
import de.quantummaid.mapmaid.mapper.deserialization.DeserializerCallback;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.TypeDeserializer;
import de.quantummaid.mapmaid.mapper.deserialization.validation.ExceptionTracker;
import de.quantummaid.mapmaid.mapper.injector.Injector;
import de.quantummaid.mapmaid.mapper.universal.Universal;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.mapmaid.shared.mapping.CustomPrimitiveMappings;
import java.util.Collections;
import java.util.List;

public final class InjectionDeserializer
implements TypeDeserializer {
    private final TypeIdentifier typeIdentifier;

    public static InjectionDeserializer injectionDeserializer(TypeIdentifier typeIdentifier) {
        return new InjectionDeserializer(typeIdentifier);
    }

    @Override
    public List<TypeIdentifier> requiredTypes() {
        return Collections.emptyList();
    }

    @Override
    public <T> T deserialize(Universal input, ExceptionTracker exceptionTracker, Injector injector, DeserializerCallback callback, CustomPrimitiveMappings customPrimitiveMappings, TypeIdentifier typeIdentifier, DebugInformation debugInformation) {
        ScanInformation scanInformation = debugInformation.scanInformationFor(this.typeIdentifier);
        throw MapMaidException.mapMaidException(String.format("Tried to deserialize type '%s' that is marked as injection-only (input was '%s')", this.typeIdentifier.description(), input.toNativeJava()), scanInformation);
    }

    @Override
    public String description() {
        return "always inject";
    }

    public String toString() {
        return "InjectionDeserializer(typeIdentifier=" + this.typeIdentifier + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InjectionDeserializer)) {
            return false;
        }
        InjectionDeserializer other = (InjectionDeserializer)o;
        TypeIdentifier this$typeIdentifier = this.typeIdentifier;
        TypeIdentifier other$typeIdentifier = other.typeIdentifier;
        return !(this$typeIdentifier == null ? other$typeIdentifier != null : !this$typeIdentifier.equals(other$typeIdentifier));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TypeIdentifier $typeIdentifier = this.typeIdentifier;
        result = result * 59 + ($typeIdentifier == null ? 43 : $typeIdentifier.hashCode());
        return result;
    }

    private InjectionDeserializer(TypeIdentifier typeIdentifier) {
        this.typeIdentifier = typeIdentifier;
    }
}

