/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.recipes.marshallers.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import de.quantummaid.mapmaid.builder.MapMaidBuilder;
import de.quantummaid.mapmaid.builder.recipes.Recipe;
import de.quantummaid.mapmaid.builder.recipes.marshallers.jackson.AlwaysStringValueJacksonDeserializerModifier;

public final class JacksonMarshaller
implements Recipe {
    private final ObjectMapper objectMapper;

    public static JacksonMarshaller jacksonMarshallerJson(ObjectMapper objectMapper) {
        return new JacksonMarshaller(objectMapper);
    }

    @Override
    public void cook(MapMaidBuilder mapMaidBuilder) {
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.setDeserializerModifier(new AlwaysStringValueJacksonDeserializerModifier());
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.objectMapper.registerModule(simpleModule);
        mapMaidBuilder.withAdvancedSettings(advancedBuilder -> advancedBuilder.usingJsonMarshaller(this.objectMapper::writeValueAsString, input -> this.objectMapper.readValue(input, Object.class)));
    }

    public String toString() {
        return "JacksonMarshaller(objectMapper=" + this.objectMapper + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JacksonMarshaller)) {
            return false;
        }
        JacksonMarshaller other = (JacksonMarshaller)o;
        ObjectMapper this$objectMapper = this.objectMapper;
        ObjectMapper other$objectMapper = other.objectMapper;
        return !(this$objectMapper == null ? other$objectMapper != null : !this$objectMapper.equals(other$objectMapper));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ObjectMapper $objectMapper = this.objectMapper;
        result = result * 59 + ($objectMapper == null ? 43 : $objectMapper.hashCode());
        return result;
    }

    private JacksonMarshaller(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

