/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.resolving.disambiguator.normal;

import de.quantummaid.mapmaid.builder.detection.DetectionResult;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.SerializersAndDeserializers;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.TypeDeserializer;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.customprimitives.CustomPrimitiveDeserializer;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.serializedobjects.SerializedObjectDeserializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.TypeSerializer;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class Picker {
    private Picker() {
    }

    public static DetectionResult<TypeSerializer> pickSerializer(SerializersAndDeserializers options) {
        List<TypeSerializer> serializers = options.serializers();
        Optional<DetectionResult<TypeSerializer>> preferredCustomPrimitive = Picker.oneOrNone(serializers, TypeSerializer::description);
        return preferredCustomPrimitive.orElseGet(() -> DetectionResult.failure("No serializers to choose from"));
    }

    public static DetectionResult<TypeDeserializer> pickDeserializer(List<TypeDeserializer> deserializers) {
        List<TypeDeserializer> customPrimitives = Picker.subTypesOf(CustomPrimitiveDeserializer.class, deserializers);
        Optional<DetectionResult<TypeDeserializer>> customPrimitive = Picker.oneOrNone(customPrimitives, TypeDeserializer::description);
        if (customPrimitive.isPresent()) {
            return customPrimitive.get();
        }
        List<TypeDeserializer> serializedObjects = Picker.subTypesOf(SerializedObjectDeserializer.class, deserializers);
        List<TypeDeserializer> maxPreferred = Picker.maxDeserializers(serializedObjects);
        Optional<DetectionResult<TypeDeserializer>> serializedObject = Picker.oneOrNone(maxPreferred, TypeDeserializer::description);
        if (serializedObject.isPresent()) {
            return serializedObject.get();
        }
        return DetectionResult.failure("No deserializers to choose from");
    }

    private static List<TypeDeserializer> maxDeserializers(List<TypeDeserializer> serializedObjectDeserializers) {
        OptionalInt max = serializedObjectDeserializers.stream().mapToInt(deserializer -> ((SerializedObjectDeserializer)deserializer).fields().fields().size()).max();
        if (max.isPresent()) {
            List<TypeDeserializer> maxDeserializers = serializedObjectDeserializers.stream().filter(deserializer -> ((SerializedObjectDeserializer)deserializer).fields().fields().size() == max.getAsInt()).collect(Collectors.toList());
            return maxDeserializers;
        }
        return Collections.emptyList();
    }

    private static <T> List<T> subTypesOf(Class<? extends T> type, List<T> elements) {
        return elements.stream().filter(type::isInstance).collect(Collectors.toList());
    }

    public static <T> Optional<DetectionResult<T>> oneOrNone(List<T> list, Function<T, String> describer) {
        if (list.size() == 1) {
            return Optional.of(DetectionResult.success(list.get(0)));
        }
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(DetectionResult.failure(String.format("Cannot decide between %n%s", Picker.plotList(list, describer))));
    }

    private static <T> String plotList(List<T> list, Function<T, String> describer) {
        return list.stream().map(describer).map(s -> "- " + s).collect(Collectors.joining("\n"));
    }
}

