/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.mapper.deserialization.deserializers.customprimitives;

import de.quantummaid.mapmaid.debug.MapMaidException;
import de.quantummaid.mapmaid.debug.scaninformation.ScanInformation;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.customprimitives.CustomPrimitiveDeserializer;
import de.quantummaid.reflectmaid.ResolvedType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public final class CustomPrimitiveAsEnumDeserializer
implements CustomPrimitiveDeserializer {
    private final ResolvedType enumType;
    private final Map<String, ? extends Enum<?>> valuesMap;

    public static CustomPrimitiveDeserializer enumDeserializer(ResolvedType enumType) {
        Enum<?>[] values = CustomPrimitiveAsEnumDeserializer.values(enumType);
        Map<String, Enum> valuesMap = Arrays.stream(values).collect(Collectors.toMap(Enum::name, value -> value));
        return new CustomPrimitiveAsEnumDeserializer(enumType, valuesMap);
    }

    @Override
    public Object deserialize(Object value) {
        if (!this.valuesMap.containsKey(value)) {
            throw MapMaidException.mapMaidException(String.format("'%s' is not valid value of enum %s", value, this.enumType.description()), new ScanInformation[0]);
        }
        return this.valuesMap.get(value);
    }

    @Override
    public String description() {
        return String.format("as custom primitive using values of enum %s", this.enumType.description());
    }

    private static Enum<?>[] values(ResolvedType enumType) {
        try {
            Method method = enumType.assignableType().getDeclaredMethod("values", new Class[0]);
            return (Enum[])method.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new UnsupportedOperationException("This should never happen", e);
        }
    }

    public String toString() {
        return "CustomPrimitiveAsEnumDeserializer(enumType=" + this.enumType + ", valuesMap=" + this.valuesMap + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomPrimitiveAsEnumDeserializer)) {
            return false;
        }
        CustomPrimitiveAsEnumDeserializer other = (CustomPrimitiveAsEnumDeserializer)o;
        ResolvedType this$enumType = this.enumType;
        ResolvedType other$enumType = other.enumType;
        if (this$enumType == null ? other$enumType != null : !this$enumType.equals(other$enumType)) {
            return false;
        }
        Map<String, Enum<?>> this$valuesMap = this.valuesMap;
        Map<String, ? extends Enum<?>> other$valuesMap = other.valuesMap;
        return !(this$valuesMap == null ? other$valuesMap != null : !((Object)this$valuesMap).equals(other$valuesMap));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResolvedType $enumType = this.enumType;
        result = result * 59 + ($enumType == null ? 43 : $enumType.hashCode());
        Map<String, Enum<?>> $valuesMap = this.valuesMap;
        result = result * 59 + ($valuesMap == null ? 43 : ((Object)$valuesMap).hashCode());
        return result;
    }

    private CustomPrimitiveAsEnumDeserializer(ResolvedType enumType, Map<String, ? extends Enum<?>> valuesMap) {
        this.enumType = enumType;
        this.valuesMap = valuesMap;
    }
}

