/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.mapper.deserialization.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

final class ThrowableRelativesLookup {
    private final Class<? extends Throwable> clazz;
    private final List<Class<? extends Throwable>> relatives;

    private ThrowableRelativesLookup(Class<? extends Throwable> clazz) {
        this.clazz = clazz;
        this.relatives = new ArrayList<Class<? extends Throwable>>(0);
        this.traverseRelatives(clazz);
    }

    static ThrowableRelativesLookup fromThrowable(Class<? extends Throwable> clazz) {
        return new ThrowableRelativesLookup(clazz);
    }

    Class<? extends Throwable> closestRelativeFrom(Collection<Class<? extends Throwable>> assignableClasses) {
        for (Class<? extends Throwable> relative : this.relatives) {
            if (!assignableClasses.stream().anyMatch(relative::equals)) continue;
            return relative;
        }
        return null;
    }

    private void traverseRelatives(Class<?> clazz) {
        if (Throwable.class.isAssignableFrom(clazz)) {
            this.relatives.add(clazz);
            Class<?> superclass = clazz.getSuperclass();
            Class<?>[] interfaces = clazz.getInterfaces();
            Arrays.stream(interfaces).forEach(this::traverseRelatives);
            if (superclass != null) {
                this.traverseRelatives(superclass);
            }
        }
    }
}

