/*
 * Decompiled with CFR 0.152.
 */
package checkers.types.visitors;

import checkers.types.AnnotatedTypeMirror;
import checkers.types.visitors.AnnotatedTypeScanner;
import java.util.Iterator;
import javacutils.ErrorReporter;

public class AnnotatedTypeComparer<R>
extends AnnotatedTypeScanner<R, AnnotatedTypeMirror> {
    @Override
    protected R scan(Iterable<? extends AnnotatedTypeMirror> types, Iterable<? extends AnnotatedTypeMirror> p) {
        if (types == null) {
            return null;
        }
        R r = null;
        boolean first = true;
        Iterator<? extends AnnotatedTypeMirror> tIter = types.iterator();
        Iterator<? extends AnnotatedTypeMirror> pIter = p.iterator();
        while (tIter.hasNext() && pIter.hasNext()) {
            r = (R)(first ? this.scan(tIter.next(), pIter.next()) : this.scanAndReduce(tIter.next(), pIter.next(), r));
            first = false;
        }
        return r;
    }

    @Override
    protected R scanAndReduce(Iterable<? extends AnnotatedTypeMirror> types, Iterable<? extends AnnotatedTypeMirror> p, R r) {
        return this.reduce(this.scan(types, p), r);
    }

    @Override
    public R scanAndReduce(AnnotatedTypeMirror type, AnnotatedTypeMirror p, R r) {
        return this.reduce(this.scan(type, p), r);
    }

    @Override
    protected R scanAndReduce(Iterable<? extends AnnotatedTypeMirror> types, AnnotatedTypeMirror p, R r) {
        ErrorReporter.errorAbort("AnnotatedTypeComparer.scanAndReduce: " + p + "is not Iterable<? extends AnnotatedTypeMirror>");
        return null;
    }

    @Override
    public final R visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type, AnnotatedTypeMirror p) {
        assert (p instanceof AnnotatedTypeMirror.AnnotatedDeclaredType) : p;
        R r = this.scan((Iterable<? extends AnnotatedTypeMirror>)type.getTypeArguments(), (Iterable<? extends AnnotatedTypeMirror>)((AnnotatedTypeMirror.AnnotatedDeclaredType)p).getTypeArguments());
        return r;
    }

    @Override
    public final R visitArray(AnnotatedTypeMirror.AnnotatedArrayType type, AnnotatedTypeMirror p) {
        assert (p instanceof AnnotatedTypeMirror.AnnotatedArrayType) : p;
        Object r = this.scan(type.getComponentType(), ((AnnotatedTypeMirror.AnnotatedArrayType)p).getComponentType());
        return r;
    }

    @Override
    public final R visitExecutable(AnnotatedTypeMirror.AnnotatedExecutableType type, AnnotatedTypeMirror p) {
        assert (p instanceof AnnotatedTypeMirror.AnnotatedExecutableType) : p;
        AnnotatedTypeMirror.AnnotatedExecutableType ex = (AnnotatedTypeMirror.AnnotatedExecutableType)p;
        Object r = this.scan(type.getReturnType(), ex.getReturnType());
        r = this.scanAndReduce((AnnotatedTypeMirror)type.getReceiverType(), (AnnotatedTypeMirror)ex.getReceiverType(), r);
        r = this.scanAndReduce((Iterable<? extends AnnotatedTypeMirror>)type.getParameterTypes(), (Iterable<? extends AnnotatedTypeMirror>)ex.getParameterTypes(), r);
        r = this.scanAndReduce((Iterable<? extends AnnotatedTypeMirror>)type.getThrownTypes(), (Iterable<? extends AnnotatedTypeMirror>)ex.getThrownTypes(), r);
        r = this.scanAndReduce((Iterable<? extends AnnotatedTypeMirror>)type.getTypeVariables(), (Iterable<? extends AnnotatedTypeMirror>)ex.getTypeVariables(), r);
        return r;
    }

    @Override
    public R visitTypeVariable(AnnotatedTypeMirror.AnnotatedTypeVariable type, AnnotatedTypeMirror p) {
        Object r;
        if (this.visitedNodes.containsKey(type)) {
            return (R)this.visitedNodes.get(type);
        }
        if (p instanceof AnnotatedTypeMirror.AnnotatedTypeVariable) {
            AnnotatedTypeMirror.AnnotatedTypeVariable tv = (AnnotatedTypeMirror.AnnotatedTypeVariable)p;
            r = this.scan(type.getLowerBound(), tv.getLowerBound());
            this.visitedNodes.put(type, r);
            r = this.scanAndReduce(type.getUpperBound(), tv.getUpperBound(), r);
            this.visitedNodes.put(type, r);
        } else {
            r = this.scan(type.getLowerBound(), p.getErased());
            this.visitedNodes.put(type, r);
            r = this.scanAndReduce(type.getUpperBound(), p, r);
            this.visitedNodes.put(type, r);
        }
        return r;
    }

    @Override
    public final R visitWildcard(AnnotatedTypeMirror.AnnotatedWildcardType type, AnnotatedTypeMirror p) {
        assert (p instanceof AnnotatedTypeMirror.AnnotatedWildcardType) : p;
        AnnotatedTypeMirror.AnnotatedWildcardType w = (AnnotatedTypeMirror.AnnotatedWildcardType)p;
        if (this.visitedNodes.containsKey(type)) {
            return (R)this.visitedNodes.get(type);
        }
        Object r = this.scan(type.getExtendsBound(), w.getExtendsBound());
        this.visitedNodes.put(type, r);
        r = this.scanAndReduce(type.getSuperBound(), w.getSuperBound(), r);
        this.visitedNodes.put(type, r);
        return r;
    }
}

