/*
 * Decompiled with CFR 0.152.
 */
package dataflow.cfg.node;

import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.Tree;
import dataflow.cfg.node.Node;
import dataflow.cfg.node.NodeVisitor;
import dataflow.util.HashCodeUtils;
import java.util.Collection;
import java.util.Collections;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

public class InstanceOfNode
extends Node {
    protected Node operand;
    protected TypeMirror refType;
    protected final InstanceOfTree tree;

    public InstanceOfNode(Tree tree, Node operand, TypeMirror refType, Types types) {
        super(types.getPrimitiveType(TypeKind.BOOLEAN));
        assert (tree.getKind() == Tree.Kind.INSTANCE_OF);
        this.tree = (InstanceOfTree)tree;
        this.operand = operand;
        this.refType = refType;
    }

    public Node getOperand() {
        return this.operand;
    }

    @Override
    public TypeMirror getType() {
        return this.type;
    }

    public TypeMirror getRefType() {
        return this.refType;
    }

    @Override
    public InstanceOfTree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitInstanceOf(this, p);
    }

    public String toString() {
        return "(" + this.getOperand() + " instanceof " + this.getRefType() + ")";
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof InstanceOfNode)) {
            return false;
        }
        InstanceOfNode other = (InstanceOfNode)obj;
        return this.getOperand().equals(other.getOperand()) && this.getRefType().equals(other.getRefType());
    }

    public int hashCode() {
        return HashCodeUtils.hash((Object)this.getOperand());
    }

    @Override
    public Collection<Node> getOperands() {
        return Collections.singletonList(this.getOperand());
    }
}

