/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.eventmaid.messagebus;

import de.quantummaid.eventmaid.channel.Channel;
import de.quantummaid.eventmaid.channel.action.Consume;
import de.quantummaid.eventmaid.identification.CorrelationId;
import de.quantummaid.eventmaid.messagebus.internal.brokering.MessageBusBrokerStrategy;
import de.quantummaid.eventmaid.messagebus.internal.correlationids.CorrelationBasedSubscriptions;
import de.quantummaid.eventmaid.processingcontext.EventType;
import de.quantummaid.eventmaid.processingcontext.ProcessingContext;
import de.quantummaid.eventmaid.subscribing.Subscriber;
import java.util.List;
import lombok.Generated;

final class MessageBusConsumeAction {
    static Consume<Object> messageBusConsumeAction(MessageBusBrokerStrategy brokerStrategy, CorrelationBasedSubscriptions correlationBasedSubscriptions) {
        return Consume.consumeMessage(objectProcessingContext -> {
            MessageBusConsumeAction.deliveryToEventTypeBasedSubscriber(objectProcessingContext, brokerStrategy);
            MessageBusConsumeAction.deliveryBasedOnCorrelationId(objectProcessingContext, correlationBasedSubscriptions);
        });
    }

    private static void deliveryToEventTypeBasedSubscriber(ProcessingContext<Object> processingContext, MessageBusBrokerStrategy brokerStrategy) {
        EventType eventType = processingContext.getEventType();
        Channel<Object> channel = brokerStrategy.getDeliveringChannelFor(eventType);
        channel.send(processingContext);
    }

    private static void deliveryBasedOnCorrelationId(ProcessingContext<Object> objectProcessingContext, CorrelationBasedSubscriptions correlationBasedSubscriptions) {
        CorrelationId correlationId = objectProcessingContext.getCorrelationId();
        List<Subscriber<ProcessingContext<Object>>> corIdSubscribers = correlationBasedSubscriptions.getSubscribersFor(correlationId);
        for (Subscriber<ProcessingContext<Object>> correlationSubscriber : corIdSubscribers) {
            correlationSubscriber.accept(objectProcessingContext);
        }
    }

    @Generated
    private MessageBusConsumeAction() {
    }
}

