/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.eventmaid.qcec.domainbus;

import de.quantummaid.eventmaid.internal.enforcing.NotNullEnforcer;
import de.quantummaid.eventmaid.messagebus.MessageBus;
import de.quantummaid.eventmaid.messagebus.MessageBusBuilder;
import de.quantummaid.eventmaid.messagebus.MessageBusType;
import de.quantummaid.eventmaid.qcec.constraintenforcing.ConstraintEnforcer;
import de.quantummaid.eventmaid.qcec.constraintenforcing.ConstraintEnforcerFactory;
import de.quantummaid.eventmaid.qcec.domainbus.DocumentBus;
import de.quantummaid.eventmaid.qcec.domainbus.DocumentBusImpl;
import de.quantummaid.eventmaid.qcec.eventbus.EventBus;
import de.quantummaid.eventmaid.qcec.eventbus.EventBusFactory;
import de.quantummaid.eventmaid.qcec.queryresolving.QueryResolver;
import de.quantummaid.eventmaid.qcec.queryresolving.QueryResolverFactory;
import lombok.Generated;

public final class DocumentBusBuilder {
    private QueryResolver queryResolver;
    private ConstraintEnforcer constraintEnforcer;
    private EventBus eventBus;

    public static DocumentBus aDefaultDocumentBus() {
        MessageBus queryMessageBus = MessageBusBuilder.aMessageBus().forType(MessageBusType.SYNCHRONOUS).build();
        MessageBus constraintMessageBus = MessageBusBuilder.aMessageBus().forType(MessageBusType.SYNCHRONOUS).build();
        MessageBus eventMessageBus = MessageBusBuilder.aMessageBus().forType(MessageBusType.SYNCHRONOUS).build();
        QueryResolver queryResolver = QueryResolverFactory.aQueryResolver(queryMessageBus);
        ConstraintEnforcer constraintEnforcer = ConstraintEnforcerFactory.aConstraintEnforcer(constraintMessageBus);
        EventBus eventBus = EventBusFactory.aEventBus(eventMessageBus);
        return DocumentBusBuilder.aDocumentBus().using(queryResolver).using(constraintEnforcer).using(eventBus).build();
    }

    public static DocumentBusBuilder aDocumentBus() {
        return new DocumentBusBuilder();
    }

    public DocumentBusBuilder using(QueryResolver queryResolver) {
        this.queryResolver = queryResolver;
        return this;
    }

    public DocumentBusBuilder using(ConstraintEnforcer constraintEnforcer) {
        this.constraintEnforcer = constraintEnforcer;
        return this;
    }

    public DocumentBusBuilder using(EventBus eventBus) {
        this.eventBus = eventBus;
        return this;
    }

    public DocumentBusImpl build() {
        NotNullEnforcer.ensureNotNull(this.queryResolver, "query resolver");
        NotNullEnforcer.ensureNotNull(this.constraintEnforcer, "constraint enforcer");
        NotNullEnforcer.ensureNotNull(this.eventBus, "event bus");
        return new DocumentBusImpl(this.queryResolver, this.constraintEnforcer, this.eventBus);
    }

    @Generated
    private DocumentBusBuilder() {
    }
}

