/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.chains;

import de.quantummaid.httpmaid.chains.ChainName;
import de.quantummaid.httpmaid.chains.ChainRegistry;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.MetaDataKey;
import de.quantummaid.httpmaid.chains.ModuleIdentifier;
import de.quantummaid.httpmaid.chains.Processor;
import de.quantummaid.httpmaid.chains.RegisteredProcessor;
import de.quantummaid.httpmaid.chains.rules.Action;
import de.quantummaid.httpmaid.chains.rules.Rule;
import de.quantummaid.httpmaid.chains.rules.RuleDescription;
import de.quantummaid.httpmaid.util.Validators;
import java.util.Optional;
import java.util.function.Predicate;
import lombok.Generated;

public final class ChainExtender {
    private final ChainRegistry chainRegistry;
    private final ModuleIdentifier moduleIdentifier;
    private final MetaData metaData;

    static ChainExtender chainExtender(ChainRegistry chainRegistry, ModuleIdentifier moduleIdentifier, MetaData metaData) {
        Validators.validateNotNull(chainRegistry, "chainRegistry");
        Validators.validateNotNull(moduleIdentifier, "moduleIdentifier");
        return new ChainExtender(chainRegistry, moduleIdentifier, metaData);
    }

    public void createChain(ChainName name, Action defaultAction, Action exceptionAction) {
        this.chainRegistry.createChain(name, defaultAction, exceptionAction, this.moduleIdentifier);
    }

    public void prependProcessor(ChainName chainName, Processor processor) {
        RegisteredProcessor registeredProcessor = RegisteredProcessor.registeredProcessor(this.moduleIdentifier, processor);
        this.chainRegistry.prependProcessorToChain(chainName, registeredProcessor);
    }

    public void appendProcessor(ChainName chainName, Processor processor) {
        RegisteredProcessor registeredProcessor = RegisteredProcessor.registeredProcessor(this.moduleIdentifier, processor);
        this.chainRegistry.appendProcessorToChain(chainName, registeredProcessor);
    }

    public <T> void routeIfEquals(ChainName name, Action action, MetaDataKey<T> key, T value) {
        this.routeIf(name, action, key, value::equals, String.format("%s = %s", key.key(), value.toString()));
    }

    public void routeIfFlagIsSet(ChainName name, Action action, MetaDataKey<Boolean> flag) {
        this.routeIf(name, action, flag, bool -> bool, flag.key());
    }

    public void routeIfSet(ChainName name, Action action, MetaDataKey<?> key) {
        this.routeIf(name, action, key, x -> true, key.key() + " present");
    }

    public <T> void routeIf(ChainName name, Action action, MetaDataKey<T> key, Predicate<T> predicate, String description) {
        this.route(name, action, m3 -> m3.getOptional(key).map(predicate::test).orElse(false), description);
    }

    public void route(ChainName name, Action action, Predicate<MetaData> matcher, String description) {
        Rule rule = Rule.rule(this.moduleIdentifier, matcher, action, RuleDescription.ruleDescription(description));
        this.chainRegistry.addRoutingRouleToChain(name, rule);
    }

    public <T> T getMetaDatum(MetaDataKey<T> key) {
        return this.metaData.get(key);
    }

    public <T> Optional<T> getOptionalMetaDatum(MetaDataKey<T> key) {
        return this.metaData.getOptional(key);
    }

    public <T> void addMetaDatum(MetaDataKey<T> key, T value) {
        this.metaData.set(key, value);
    }

    @Generated
    public String toString() {
        return "ChainExtender(chainRegistry=" + this.chainRegistry + ", moduleIdentifier=" + this.moduleIdentifier + ", metaData=" + this.metaData + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChainExtender)) {
            return false;
        }
        ChainExtender other = (ChainExtender)o;
        ChainRegistry this$chainRegistry = this.chainRegistry;
        ChainRegistry other$chainRegistry = other.chainRegistry;
        if (this$chainRegistry == null ? other$chainRegistry != null : !this$chainRegistry.equals(other$chainRegistry)) {
            return false;
        }
        ModuleIdentifier this$moduleIdentifier = this.moduleIdentifier;
        ModuleIdentifier other$moduleIdentifier = other.moduleIdentifier;
        if (this$moduleIdentifier == null ? other$moduleIdentifier != null : !((Object)this$moduleIdentifier).equals(other$moduleIdentifier)) {
            return false;
        }
        MetaData this$metaData = this.metaData;
        MetaData other$metaData = other.metaData;
        return !(this$metaData == null ? other$metaData != null : !((Object)this$metaData).equals(other$metaData));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ChainRegistry $chainRegistry = this.chainRegistry;
        result = result * 59 + ($chainRegistry == null ? 43 : $chainRegistry.hashCode());
        ModuleIdentifier $moduleIdentifier = this.moduleIdentifier;
        result = result * 59 + ($moduleIdentifier == null ? 43 : ((Object)$moduleIdentifier).hashCode());
        MetaData $metaData = this.metaData;
        result = result * 59 + ($metaData == null ? 43 : ((Object)$metaData).hashCode());
        return result;
    }

    @Generated
    private ChainExtender(ChainRegistry chainRegistry, ModuleIdentifier moduleIdentifier, MetaData metaData) {
        this.chainRegistry = chainRegistry;
        this.moduleIdentifier = moduleIdentifier;
        this.metaData = metaData;
    }
}

