/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.chains.builder;

import de.quantummaid.httpmaid.chains.ChainExtender;
import de.quantummaid.httpmaid.chains.ChainName;
import de.quantummaid.httpmaid.chains.Processor;
import de.quantummaid.httpmaid.chains.builder.ChainBuilderEntry;
import de.quantummaid.httpmaid.chains.rules.Action;
import de.quantummaid.httpmaid.chains.rules.Jump;
import de.quantummaid.httpmaid.util.Validators;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;

public final class ChainBuilder {
    private final ChainExtender extender;
    private final List<ChainBuilderEntry> chains;
    private ChainName exceptionChainName;

    public static ChainBuilder extendAChainWith(ChainExtender chainExtender) {
        return new ChainBuilder(chainExtender, new LinkedList<ChainBuilderEntry>());
    }

    public ChainBuilder append(ChainName chainName, Processor ... processors) {
        return this.append(chainName, Arrays.asList(processors));
    }

    public ChainBuilder append(ChainName chainName, List<Processor> processors) {
        Validators.validateNotNull(chainName, "chainName");
        Validators.validateNotNull(processors, "processors");
        ChainBuilderEntry entry = ChainBuilderEntry.chainBuilderEntry(chainName, processors);
        this.chains.add(entry);
        return this;
    }

    public ChainBuilder withTheExceptionChain(ChainName exceptionChainName) {
        Validators.validateNotNull(exceptionChainName, "exceptionChainName");
        this.exceptionChainName = exceptionChainName;
        return this;
    }

    public void withTheFinalAction(Action finalAction) {
        Collections.reverse(this.chains);
        Jump exceptionAction = Jump.jumpTo(this.exceptionChainName);
        Action action = finalAction;
        for (ChainBuilderEntry entry : this.chains) {
            ChainName name = entry.chainName();
            ChainBuilder.createChain(this.extender, name, action, exceptionAction, entry.processors());
            action = Jump.jumpTo(name);
        }
    }

    private static void createChain(ChainExtender chainExtender, ChainName chainName, Action action, Action exceptionAction, List<? extends Processor> processors) {
        chainExtender.createChain(chainName, action, exceptionAction);
        processors.forEach(processor -> chainExtender.appendProcessor(chainName, (Processor)processor));
    }

    @Generated
    public String toString() {
        return "ChainBuilder(extender=" + this.extender + ", chains=" + this.chains + ", exceptionChainName=" + this.exceptionChainName + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChainBuilder)) {
            return false;
        }
        ChainBuilder other = (ChainBuilder)o;
        ChainExtender this$extender = this.extender;
        ChainExtender other$extender = other.extender;
        if (this$extender == null ? other$extender != null : !((Object)this$extender).equals(other$extender)) {
            return false;
        }
        List<ChainBuilderEntry> this$chains = this.chains;
        List<ChainBuilderEntry> other$chains = other.chains;
        if (this$chains == null ? other$chains != null : !((Object)this$chains).equals(other$chains)) {
            return false;
        }
        ChainName this$exceptionChainName = this.exceptionChainName;
        ChainName other$exceptionChainName = other.exceptionChainName;
        return !(this$exceptionChainName == null ? other$exceptionChainName != null : !((Object)this$exceptionChainName).equals(other$exceptionChainName));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ChainExtender $extender = this.extender;
        result = result * 59 + ($extender == null ? 43 : ((Object)$extender).hashCode());
        List<ChainBuilderEntry> $chains = this.chains;
        result = result * 59 + ($chains == null ? 43 : ((Object)$chains).hashCode());
        ChainName $exceptionChainName = this.exceptionChainName;
        result = result * 59 + ($exceptionChainName == null ? 43 : ((Object)$exceptionChainName).hashCode());
        return result;
    }

    @Generated
    private ChainBuilder(ChainExtender extender, List<ChainBuilderEntry> chains) {
        this.extender = extender;
        this.chains = chains;
    }
}

