/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.security.filtering;

import de.quantummaid.httpmaid.chains.ChainName;
import de.quantummaid.httpmaid.chains.DependencyRegistry;
import de.quantummaid.httpmaid.handler.http.HttpHandler;
import de.quantummaid.httpmaid.security.Filter;
import de.quantummaid.httpmaid.security.authorization.AuthorizerConfigurator;
import de.quantummaid.httpmaid.security.config.SecurityConfigurator;
import de.quantummaid.httpmaid.util.Validators;
import lombok.Generated;

public final class FilterConfigurator
implements SecurityConfigurator<FilterConfigurator> {
    private final AuthorizerConfigurator authorizerConfigurator;

    public static FilterConfigurator filterConfigurator(Filter filter) {
        Validators.validateNotNull(filter, "filter");
        AuthorizerConfigurator authorizerConfigurator = AuthorizerConfigurator.authorizerConfigurator((authenticationInformation, request) -> !filter.filter(request));
        return new FilterConfigurator(authorizerConfigurator);
    }

    @Override
    public FilterConfigurator onlyRequestsThat(Filter filter) {
        this.authorizerConfigurator.onlyRequestsThat(filter);
        return this;
    }

    @Override
    public FilterConfigurator inPhase(ChainName phase) {
        this.authorizerConfigurator.inPhase(phase);
        return this;
    }

    public FilterConfigurator rejectingFilteredRequestsUsing(HttpHandler rejectionHandler) {
        this.authorizerConfigurator.rejectingUnauthorizedRequestsUsing(rejectionHandler);
        return this;
    }

    @Override
    public void configure(DependencyRegistry dependencyRegistry) {
        this.authorizerConfigurator.configure(dependencyRegistry);
    }

    @Generated
    public String toString() {
        return "FilterConfigurator(authorizerConfigurator=" + this.authorizerConfigurator + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FilterConfigurator)) {
            return false;
        }
        FilterConfigurator other = (FilterConfigurator)o;
        AuthorizerConfigurator this$authorizerConfigurator = this.authorizerConfigurator;
        AuthorizerConfigurator other$authorizerConfigurator = other.authorizerConfigurator;
        return !(this$authorizerConfigurator == null ? other$authorizerConfigurator != null : !((Object)this$authorizerConfigurator).equals(other$authorizerConfigurator));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AuthorizerConfigurator $authorizerConfigurator = this.authorizerConfigurator;
        result = result * 59 + ($authorizerConfigurator == null ? 43 : ((Object)$authorizerConfigurator).hashCode());
        return result;
    }

    @Generated
    private FilterConfigurator(AuthorizerConfigurator authorizerConfigurator) {
        this.authorizerConfigurator = authorizerConfigurator;
    }
}

