/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.util;

import de.quantummaid.httpmaid.util.CustomTypeValidationException;

public final class Validators {
    private Validators() {
    }

    public static void validateNotNull(Object value, String name) {
        if (value == null) {
            throw CustomTypeValidationException.customTypeValidationException(name + " must not be null");
        }
    }

    public static void validateNotNullNorEmpty(String value, String name) {
        if (value == null || value.trim().isEmpty()) {
            throw CustomTypeValidationException.customTypeValidationException(name + " must not be empty");
        }
    }

    public static <T> void validateArrayNeitherNullNorEmptyNorContainsNull(T[] array, String name) {
        Validators.validateNotNull(array, name);
        if (array.length == 0) {
            throw CustomTypeValidationException.customTypeValidationException(name + " must not be empty");
        }
        for (int i = 0; i < array.length; ++i) {
            Validators.validateNotNull(array[i], name + "[" + i + "]");
        }
    }
}

