/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder;

import de.quantummaid.mapmaid.Collection;
import de.quantummaid.mapmaid.builder.MarshallerAndUnmarshaller;
import de.quantummaid.mapmaid.builder.autoload.ActualAutoloadable;
import de.quantummaid.mapmaid.builder.autoload.Autoloadable;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.Disambiguator;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.Disambiguators;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.DisambiguatorBuilder;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.NormalDisambiguator;
import de.quantummaid.mapmaid.mapper.marshalling.Marshaller;
import de.quantummaid.mapmaid.mapper.marshalling.MarshallerRegistry;
import de.quantummaid.mapmaid.mapper.marshalling.MarshallingType;
import de.quantummaid.mapmaid.mapper.marshalling.Unmarshaller;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import de.quantummaid.reflectmaid.ResolvedType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public final class AdvancedBuilder {
    private static final List<Autoloadable<MarshallerAndUnmarshaller>> AUTOLOADABLE_MARSHALLERS = List.of(ActualAutoloadable.autoloadIfClassPresent("de.quantummaid.mapmaid.jackson.JacksonJsonMarshaller"), ActualAutoloadable.autoloadIfClassPresent("de.quantummaid.mapmaid.jackson.JacksonXmlMarshaller"), ActualAutoloadable.autoloadIfClassPresent("de.quantummaid.mapmaid.jackson.JacksonYamlMarshaller"));
    private Map<MarshallingType, Marshaller> marshallerMap = Collection.smallMap();
    private Map<MarshallingType, Unmarshaller> unmarshallerMap = Collection.smallMap();
    private final DisambiguatorBuilder defaultDisambiguatorBuilder = DisambiguatorBuilder.defaultDisambiguatorBuilder();
    private boolean autoloadMarshallers = true;
    private List<MarshallerAndUnmarshaller> autoloadedMarshallers = null;

    public static AdvancedBuilder advancedBuilder() {
        return new AdvancedBuilder();
    }

    public AdvancedBuilder withPreferredCustomPrimitiveFactoryName(String name) {
        this.defaultDisambiguatorBuilder.setPreferredCustomPrimitiveFactoryName(name);
        return this;
    }

    public AdvancedBuilder withPreferredCustomPrimitiveSerializationMethodName(String name) {
        this.defaultDisambiguatorBuilder.setPreferredCustomPrimitiveSerializationMethodName(name);
        return this;
    }

    public AdvancedBuilder withPreferredSerializedObjectFactoryName(String name) {
        this.defaultDisambiguatorBuilder.setPreferredSerializedObjectFactoryName(name);
        return this;
    }

    public AdvancedBuilder doNotAutoloadMarshallers() {
        this.autoloadMarshallers = false;
        return this;
    }

    public AdvancedBuilder usingMarshaller(MarshallerAndUnmarshaller marshallerAndUnmarshaller) {
        MarshallingType marshallingType = marshallerAndUnmarshaller.marshallingType();
        Marshaller marshaller = marshallerAndUnmarshaller.marshaller();
        Unmarshaller unmarshaller = marshallerAndUnmarshaller.unmarshaller();
        return this.usingMarshaller(marshallingType, marshaller, unmarshaller);
    }

    public AdvancedBuilder usingMarshaller(MarshallingType marshallingType, Marshaller marshaller, Unmarshaller unmarshaller) {
        NotNullValidator.validateNotNull(marshaller, "marshaller");
        NotNullValidator.validateNotNull(unmarshaller, "unmarshaller");
        NotNullValidator.validateNotNull(marshallingType, "marshallingType");
        this.marshallerMap.put(marshallingType, marshaller);
        this.unmarshallerMap.put(marshallingType, unmarshaller);
        return this.doNotAutoloadMarshallers();
    }

    public AdvancedBuilder usingMarshaller(Map<MarshallingType, Marshaller> marshallerMap, Map<MarshallingType, Unmarshaller> unmarshallerMap) {
        this.marshallerMap = new HashMap<MarshallingType, Marshaller>(marshallerMap);
        this.unmarshallerMap = new HashMap<MarshallingType, Unmarshaller>(unmarshallerMap);
        return this.doNotAutoloadMarshallers();
    }

    public AdvancedBuilder usingJsonMarshaller(Marshaller marshaller, Unmarshaller unmarshaller) {
        NotNullValidator.validateNotNull(marshaller, "jsonMarshaller");
        NotNullValidator.validateNotNull(unmarshaller, "jsonUnmarshaller");
        return this.usingMarshaller(MarshallingType.JSON, marshaller, unmarshaller);
    }

    public AdvancedBuilder usingYamlMarshaller(Marshaller marshaller, Unmarshaller unmarshaller) {
        NotNullValidator.validateNotNull(marshaller, "yamlMarshaller");
        NotNullValidator.validateNotNull(unmarshaller, "yamlUnmarshaller");
        return this.usingMarshaller(MarshallingType.YAML, marshaller, unmarshaller);
    }

    public AdvancedBuilder usingXmlMarshaller(Marshaller marshaller, Unmarshaller unmarshaller) {
        NotNullValidator.validateNotNull(marshaller, "xmlMarshaller");
        NotNullValidator.validateNotNull(unmarshaller, "xmlUnmarshaller");
        return this.usingMarshaller(MarshallingType.XML, marshaller, unmarshaller);
    }

    Disambiguators buildDisambiguators() {
        NormalDisambiguator defaultDisambiguator = this.defaultDisambiguatorBuilder.build();
        Map<ResolvedType, Disambiguator> specialDisambiguators = Collection.smallMap();
        return Disambiguators.disambiguators(defaultDisambiguator, specialDisambiguators);
    }

    MarshallerRegistry<Marshaller> buildMarshallerRegistry() {
        if (this.autoloadMarshallers) {
            this.autoload();
            this.autoloadedMarshallers.forEach(autoloadableMarshaller -> {
                MarshallingType marshallingType = autoloadableMarshaller.marshallingType();
                Marshaller marshaller = autoloadableMarshaller.marshaller();
                this.marshallerMap.put(marshallingType, marshaller);
            });
        }
        return MarshallerRegistry.marshallerRegistry(this.marshallerMap);
    }

    MarshallerRegistry<Unmarshaller> buildUnmarshallerRegistry() {
        if (this.autoloadMarshallers) {
            this.autoload();
            this.autoloadedMarshallers.forEach(autoloadableMarshaller -> {
                MarshallingType marshallingType = autoloadableMarshaller.marshallingType();
                Unmarshaller unmarshaller = autoloadableMarshaller.unmarshaller();
                this.unmarshallerMap.put(marshallingType, unmarshaller);
            });
        }
        return MarshallerRegistry.marshallerRegistry(this.unmarshallerMap);
    }

    private void autoload() {
        if (this.autoloadedMarshallers == null) {
            this.autoloadedMarshallers = AUTOLOADABLE_MARSHALLERS.stream().map(Autoloadable::autoload).flatMap(Optional::stream).collect(Collectors.toList());
        }
    }

    @Generated
    public String toString() {
        return "AdvancedBuilder(marshallerMap=" + this.marshallerMap + ", unmarshallerMap=" + this.unmarshallerMap + ", defaultDisambiguatorBuilder=" + this.defaultDisambiguatorBuilder + ", autoloadMarshallers=" + this.autoloadMarshallers + ", autoloadedMarshallers=" + this.autoloadedMarshallers + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdvancedBuilder)) {
            return false;
        }
        AdvancedBuilder other = (AdvancedBuilder)o;
        Map<MarshallingType, Marshaller> this$marshallerMap = this.marshallerMap;
        Map<MarshallingType, Marshaller> other$marshallerMap = other.marshallerMap;
        if (this$marshallerMap == null ? other$marshallerMap != null : !((Object)this$marshallerMap).equals(other$marshallerMap)) {
            return false;
        }
        Map<MarshallingType, Unmarshaller> this$unmarshallerMap = this.unmarshallerMap;
        Map<MarshallingType, Unmarshaller> other$unmarshallerMap = other.unmarshallerMap;
        if (this$unmarshallerMap == null ? other$unmarshallerMap != null : !((Object)this$unmarshallerMap).equals(other$unmarshallerMap)) {
            return false;
        }
        DisambiguatorBuilder this$defaultDisambiguatorBuilder = this.defaultDisambiguatorBuilder;
        DisambiguatorBuilder other$defaultDisambiguatorBuilder = other.defaultDisambiguatorBuilder;
        if (this$defaultDisambiguatorBuilder == null ? other$defaultDisambiguatorBuilder != null : !((Object)this$defaultDisambiguatorBuilder).equals(other$defaultDisambiguatorBuilder)) {
            return false;
        }
        if (this.autoloadMarshallers != other.autoloadMarshallers) {
            return false;
        }
        List<MarshallerAndUnmarshaller> this$autoloadedMarshallers = this.autoloadedMarshallers;
        List<MarshallerAndUnmarshaller> other$autoloadedMarshallers = other.autoloadedMarshallers;
        return !(this$autoloadedMarshallers == null ? other$autoloadedMarshallers != null : !((Object)this$autoloadedMarshallers).equals(other$autoloadedMarshallers));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<MarshallingType, Marshaller> $marshallerMap = this.marshallerMap;
        result = result * 59 + ($marshallerMap == null ? 43 : ((Object)$marshallerMap).hashCode());
        Map<MarshallingType, Unmarshaller> $unmarshallerMap = this.unmarshallerMap;
        result = result * 59 + ($unmarshallerMap == null ? 43 : ((Object)$unmarshallerMap).hashCode());
        DisambiguatorBuilder $defaultDisambiguatorBuilder = this.defaultDisambiguatorBuilder;
        result = result * 59 + ($defaultDisambiguatorBuilder == null ? 43 : ((Object)$defaultDisambiguatorBuilder).hashCode());
        result = result * 59 + (this.autoloadMarshallers ? 79 : 97);
        List<MarshallerAndUnmarshaller> $autoloadedMarshallers = this.autoloadedMarshallers;
        result = result * 59 + ($autoloadedMarshallers == null ? 43 : ((Object)$autoloadedMarshallers).hashCode());
        return result;
    }

    @Generated
    private AdvancedBuilder() {
    }
}

