/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.resolving.disambiguator.normal;

import de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.DisambiguationContext;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.preferences.Filter;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.preferences.FilterResult;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.TypeDeserializer;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.customprimitives.CustomPrimitiveByConstructorDeserializer;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.customprimitives.CustomPrimitiveByMethodDeserializer;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.serializedobjects.ConstructorSerializedObjectDeserializer;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.serializedobjects.MethodSerializedObjectDeserializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.TypeSerializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.customprimitives.MethodCustomPrimitiveSerializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.serializedobject.SerializationField;
import de.quantummaid.mapmaid.mapper.serialization.serializers.serializedobject.queries.PublicFieldQuery;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.reflectmaid.resolver.ResolvedField;
import de.quantummaid.reflectmaid.resolver.ResolvedMethod;
import java.util.function.Predicate;

final class CommonFilters {
    private CommonFilters() {
    }

    static Filter<TypeDeserializer, DisambiguationContext> ignoreNonPublicMethodsForCustomPrimitiveDeserialization() {
        return Filter.filterOfType(CustomPrimitiveByMethodDeserializer.class, (deserializer, context) -> {
            if (deserializer.method().isPublic()) {
                return FilterResult.allowed();
            }
            return FilterResult.denied("only public static methods are considered for deserialization");
        });
    }

    static Filter<TypeSerializer, DisambiguationContext> ignoreNonPublicConstructorsForCustomPrimitiveSerialization() {
        return Filter.filterOfType(MethodCustomPrimitiveSerializer.class, (serializer, context) -> {
            if (serializer.method().isPublic()) {
                return FilterResult.allowed();
            }
            return FilterResult.denied("only public methods are considered for serialization");
        });
    }

    static Filter<TypeDeserializer, DisambiguationContext> ignoreNonPublicConstructorsForCustomPrimitiveDeserialization() {
        return Filter.filterOfType(CustomPrimitiveByConstructorDeserializer.class, (deserializer, context) -> {
            if (deserializer.constructor().isPublic()) {
                return FilterResult.allowed();
            }
            return FilterResult.denied("only public constructors are considered for deserialization");
        });
    }

    static Filter<TypeDeserializer, DisambiguationContext> ignoreNonPublicMethodsForSerializedObjectDeserialization() {
        return Filter.filterOfType(MethodSerializedObjectDeserializer.class, (deserializer, context) -> {
            if (deserializer.method().isPublic()) {
                return FilterResult.allowed();
            }
            return FilterResult.denied("only public static methods are considered for deserialization");
        });
    }

    static Filter<TypeDeserializer, DisambiguationContext> ignoreNonPublicConstructorsForSerializedObjectDeserialization() {
        return Filter.filterOfType(ConstructorSerializedObjectDeserializer.class, (deserializer, context) -> {
            if (deserializer.constructor().isPublic()) {
                return FilterResult.allowed();
            }
            return FilterResult.denied("only public constructors are considered for deserialization");
        });
    }

    static Filter<TypeSerializer, DisambiguationContext> nameOfSerializerMethodIsNot(String name) {
        return (serializer, context) -> {
            if (!(serializer instanceof MethodCustomPrimitiveSerializer)) {
                return FilterResult.allowed();
            }
            ResolvedMethod method = ((MethodCustomPrimitiveSerializer)serializer).method();
            boolean matchesName = method.name().equals(name);
            if (!matchesName) {
                return FilterResult.allowed();
            }
            return FilterResult.denied(String.format("method '%s' is not considered", name));
        };
    }

    static Filter<SerializationField, DisambiguationContext> ignoreInjectedFields() {
        return (serializationField, context) -> {
            TypeIdentifier type = serializationField.type();
            if (context.isInjected(type)) {
                return FilterResult.denied("fields whose type is registered as injection-only are not serialized");
            }
            return FilterResult.allowed();
        };
    }

    static Filter<SerializationField, DisambiguationContext> ignoreStaticFields() {
        return CommonFilters.ignoreFieldsThat(ResolvedField::isStatic, "static fields are not serialized");
    }

    static Filter<SerializationField, DisambiguationContext> ignoreTransientFields() {
        return CommonFilters.ignoreFieldsThat(ResolvedField::isTransient, "transient fields are not serialized");
    }

    static Filter<SerializationField, DisambiguationContext> ignoreNonPublicFields() {
        return CommonFilters.ignoreFieldsThat(resolvedField -> !resolvedField.isPublic(), "only public fields are serialized");
    }

    private static Filter<SerializationField, DisambiguationContext> ignoreFieldsThat(Predicate<ResolvedField> fieldPredicate, String message) {
        return (field, context) -> {
            if (!(field.getQuery() instanceof PublicFieldQuery)) {
                return FilterResult.allowed();
            }
            PublicFieldQuery query = (PublicFieldQuery)field.getQuery();
            ResolvedField resolvedField = query.field();
            if (fieldPredicate.test(resolvedField)) {
                return FilterResult.denied(message);
            }
            return FilterResult.allowed();
        };
    }
}

