/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.resolving.processing;

import de.quantummaid.mapmaid.builder.resolving.Context;
import de.quantummaid.mapmaid.builder.resolving.Report;
import de.quantummaid.mapmaid.builder.resolving.processing.Processor;
import de.quantummaid.mapmaid.builder.resolving.processing.Signal;
import de.quantummaid.mapmaid.builder.resolving.processing.factories.StateFactories;
import de.quantummaid.mapmaid.builder.resolving.states.StatefulDefinition;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public final class States {
    private final StateFactories stateFactories;
    private final List<StatefulDefinition> states;

    public static States states(List<StatefulDefinition> initialDefinitions) {
        ArrayList<StatefulDefinition> states = new ArrayList<StatefulDefinition>(initialDefinitions);
        return new States(StateFactories.defaultStateFactories(), states);
    }

    public States addState(StatefulDefinition statefulDefinition) {
        if (States.contains(statefulDefinition.type(), this.states)) {
            throw new IllegalArgumentException(String.format("state for type '%s' is already registered", statefulDefinition.type().description()));
        }
        ArrayList<StatefulDefinition> newStates = new ArrayList<StatefulDefinition>(this.states);
        newStates.add(statefulDefinition);
        return new States(this.stateFactories, newStates);
    }

    public List<TypeIdentifier> injections() {
        return this.states.stream().filter(StatefulDefinition::isInjection).map(StatefulDefinition::type).collect(Collectors.toList());
    }

    public States apply(Signal signal, Processor processor) {
        ArrayList<StatefulDefinition> newStates;
        Optional<TypeIdentifier> optionalTarget = signal.target();
        if (optionalTarget.isEmpty()) {
            List<StatefulDefinition> newStates2 = this.states.stream().map(signal::handleState).collect(Collectors.toList());
            return new States(this.stateFactories, newStates2);
        }
        TypeIdentifier target = optionalTarget.get();
        if (!States.contains(target, newStates = new ArrayList<StatefulDefinition>(this.states))) {
            Context context = Context.emptyContext(processor::dispatch, target);
            StatefulDefinition state = this.stateFactories.createState(target, context);
            newStates.add(state);
        }
        newStates.replaceAll(statefulDefinition -> {
            if (statefulDefinition.context.type().equals(target)) {
                return signal.handleState((StatefulDefinition)statefulDefinition);
            }
            return statefulDefinition;
        });
        return new States(this.stateFactories, newStates);
    }

    public Map<TypeIdentifier, Report> collect() {
        HashMap<TypeIdentifier, Report> reports = new HashMap<TypeIdentifier, Report>();
        this.states.forEach(statefulDefinition -> statefulDefinition.getDefinition().ifPresent(report -> {
            TypeIdentifier type = statefulDefinition.context.type();
            reports.put(type, (Report)report);
        }));
        return reports;
    }

    private static boolean contains(TypeIdentifier type, List<StatefulDefinition> states) {
        return states.stream().anyMatch(statefulDefinition -> statefulDefinition.context.type().equals(type));
    }

    @Generated
    public String toString() {
        return "States(stateFactories=" + this.stateFactories + ", states=" + this.states + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof States)) {
            return false;
        }
        States other = (States)o;
        StateFactories this$stateFactories = this.stateFactories;
        StateFactories other$stateFactories = other.stateFactories;
        if (this$stateFactories == null ? other$stateFactories != null : !((Object)this$stateFactories).equals(other$stateFactories)) {
            return false;
        }
        List<StatefulDefinition> this$states = this.states;
        List<StatefulDefinition> other$states = other.states;
        return !(this$states == null ? other$states != null : !((Object)this$states).equals(other$states));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StateFactories $stateFactories = this.stateFactories;
        result = result * 59 + ($stateFactories == null ? 43 : ((Object)$stateFactories).hashCode());
        List<StatefulDefinition> $states = this.states;
        result = result * 59 + ($states == null ? 43 : ((Object)$states).hashCode());
        return result;
    }

    @Generated
    private States(StateFactories stateFactories, List<StatefulDefinition> states) {
        this.stateFactories = stateFactories;
        this.states = states;
    }
}

