/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.debug;

import de.quantummaid.mapmaid.Collection;
import de.quantummaid.mapmaid.debug.SubReasonProvider;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public final class Reason {
    private final String reason;
    private final TypeIdentifier parent;

    public static Reason reason(String reason) {
        NotNullValidator.validateNotNull(reason, "reason");
        return new Reason(reason, null);
    }

    public static Reason manuallyAdded() {
        return Reason.reason("manually added");
    }

    public static Reason becauseOf(TypeIdentifier parent) {
        return new Reason(String.format("because of %s", parent.description()), parent);
    }

    public List<String> render(SubReasonProvider subReasonProvider) {
        return this.renderRecursive(subReasonProvider, Collection.smallList());
    }

    private List<String> renderRecursive(SubReasonProvider subReasonProvider, List<Reason> alreadyVisitedReasons) {
        if (this.parent == null) {
            return Collections.singletonList(this.reason);
        }
        String parentName = this.parent.description();
        if (alreadyVisitedReasons.contains(this)) {
            return Collections.singletonList(String.format("%s...", parentName));
        }
        alreadyVisitedReasons.add(this);
        List<Reason> parentReasons = subReasonProvider.reasonsFor(this.parent);
        return parentReasons.stream().map(parentReason -> parentReason.renderRecursive(subReasonProvider, alreadyVisitedReasons)).flatMap(java.util.Collection::stream).map(parentReason -> parentName + " -> " + parentReason).collect(Collectors.toList());
    }

    @Generated
    public String toString() {
        return "Reason(reason=" + this.reason + ", parent=" + this.parent + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Reason)) {
            return false;
        }
        Reason other = (Reason)o;
        String this$reason = this.reason;
        String other$reason = other.reason;
        if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
            return false;
        }
        TypeIdentifier this$parent = this.parent;
        TypeIdentifier other$parent = other.parent;
        return !(this$parent == null ? other$parent != null : !this$parent.equals(other$parent));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $reason = this.reason;
        result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
        TypeIdentifier $parent = this.parent;
        result = result * 59 + ($parent == null ? 43 : $parent.hashCode());
        return result;
    }

    @Generated
    private Reason(String reason, TypeIdentifier parent) {
        this.reason = reason;
        this.parent = parent;
    }
}

