/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.mapper.deserialization;

import de.quantummaid.mapmaid.mapper.deserialization.UnmarshallingException;
import de.quantummaid.mapmaid.mapper.marshalling.MarshallerRegistry;
import de.quantummaid.mapmaid.mapper.marshalling.MarshallingType;
import de.quantummaid.mapmaid.mapper.marshalling.Unmarshaller;
import de.quantummaid.mapmaid.mapper.universal.Universal;
import de.quantummaid.mapmaid.mapper.universal.UniversalNull;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import java.util.Set;
import lombok.Generated;

final class Unmarshallers {
    private final MarshallerRegistry<Unmarshaller> unmarshallers;

    static Unmarshallers unmarshallers(MarshallerRegistry<Unmarshaller> unmarshallers) {
        NotNullValidator.validateNotNull(unmarshallers, "unmarshallers");
        return new Unmarshallers(unmarshallers);
    }

    Universal unmarshall(String input, MarshallingType marshallingType) {
        NotNullValidator.validateNotNull(input, "input");
        if (input.isEmpty()) {
            return UniversalNull.universalNull();
        }
        Unmarshaller unmarshaller = this.unmarshallers.getForType(marshallingType);
        String trimmedInput = input.trim();
        try {
            Object unmarshalled = unmarshaller.unmarshal(trimmedInput);
            return Universal.fromNativeJava(unmarshalled);
        }
        catch (Exception e) {
            throw UnmarshallingException.unmarshallingException(input, e);
        }
    }

    Set<MarshallingType> supportedMarshallingTypes() {
        return this.unmarshallers.supportedTypes();
    }

    @Generated
    public String toString() {
        return "Unmarshallers(unmarshallers=" + this.unmarshallers + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Unmarshallers)) {
            return false;
        }
        Unmarshallers other = (Unmarshallers)o;
        MarshallerRegistry<Unmarshaller> this$unmarshallers = this.unmarshallers;
        MarshallerRegistry<Unmarshaller> other$unmarshallers = other.unmarshallers;
        return !(this$unmarshallers == null ? other$unmarshallers != null : !((Object)this$unmarshallers).equals(other$unmarshallers));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MarshallerRegistry<Unmarshaller> $unmarshallers = this.unmarshallers;
        result = result * 59 + ($unmarshallers == null ? 43 : ((Object)$unmarshallers).hashCode());
        return result;
    }

    @Generated
    private Unmarshallers(MarshallerRegistry<Unmarshaller> unmarshallers) {
        this.unmarshallers = unmarshallers;
    }
}

