/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.mapper.deserialization.validation;

import de.quantummaid.mapmaid.mapper.deserialization.validation.ExceptionMappingList;
import de.quantummaid.mapmaid.mapper.deserialization.validation.TrackingPosition;
import de.quantummaid.mapmaid.mapper.deserialization.validation.UnrecognizedExceptionOccurredException;
import de.quantummaid.mapmaid.mapper.deserialization.validation.ValidationError;
import de.quantummaid.mapmaid.mapper.deserialization.validation.ValidationMappings;
import de.quantummaid.mapmaid.mapper.deserialization.validation.ValidationResult;
import de.quantummaid.mapmaid.mapper.universal.Universal;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public final class ExceptionTracker {
    private final TrackingPosition position;
    private final ValidationMappings validationMappings;
    private final Universal originalInput;
    private final List<ValidationError> validationErrors = new ArrayList<ValidationError>(3);
    private final List<ExceptionTracker> children = new ArrayList<ExceptionTracker>(3);

    public static ExceptionTracker emptyTracker(Universal originalInput, ValidationMappings validationMappings) {
        return ExceptionTracker.initializedTracker(TrackingPosition.empty(), validationMappings, originalInput);
    }

    private static ExceptionTracker initializedTracker(TrackingPosition position, ValidationMappings validationMappings, Universal originalInput) {
        return new ExceptionTracker(position, validationMappings, originalInput);
    }

    private static Throwable resolveThrowable(Throwable raw) {
        if (raw instanceof InvocationTargetException) {
            return ((InvocationTargetException)raw).getTargetException();
        }
        return raw;
    }

    public void track(Throwable e, String messageProvidingDebugInformation) {
        Throwable resolvedThrowable = ExceptionTracker.resolveThrowable(e);
        ExceptionMappingList<Throwable> exceptionMapping = this.validationMappings.get(resolvedThrowable.getClass()).orElseThrow(() -> UnrecognizedExceptionOccurredException.fromException(messageProvidingDebugInformation, this.position, resolvedThrowable, this.originalInput.toNativeJava()));
        List<ValidationError> mapped = exceptionMapping.map(resolvedThrowable, this.position.render());
        this.validationErrors.addAll(mapped);
    }

    public ExceptionTracker stepInto(String name) {
        ExceptionTracker exceptionTracker = ExceptionTracker.initializedTracker(this.position.next(name), this.validationMappings, this.originalInput);
        this.children.add(exceptionTracker);
        return exceptionTracker;
    }

    public ExceptionTracker stepIntoArray(int index) {
        return this.stepInto(String.format("[%d]", index));
    }

    public ValidationResult validationResult() {
        return ValidationResult.validationResult(this.allValidationErrors());
    }

    private List<ValidationError> allValidationErrors() {
        ArrayList<ValidationError> allValidationErrors = new ArrayList<ValidationError>(this.validationErrors);
        this.children.forEach(child -> allValidationErrors.addAll(child.allValidationErrors()));
        return allValidationErrors;
    }

    public String getPosition() {
        return this.position.render();
    }

    @Generated
    public String toString() {
        return "ExceptionTracker(position=" + this.getPosition() + ", validationMappings=" + this.validationMappings + ", originalInput=" + this.originalInput + ", validationErrors=" + this.validationErrors + ", children=" + this.children + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExceptionTracker)) {
            return false;
        }
        ExceptionTracker other = (ExceptionTracker)o;
        String this$position = this.getPosition();
        String other$position = other.getPosition();
        if (this$position == null ? other$position != null : !this$position.equals(other$position)) {
            return false;
        }
        ValidationMappings this$validationMappings = this.validationMappings;
        ValidationMappings other$validationMappings = other.validationMappings;
        if (this$validationMappings == null ? other$validationMappings != null : !((Object)this$validationMappings).equals(other$validationMappings)) {
            return false;
        }
        Universal this$originalInput = this.originalInput;
        Universal other$originalInput = other.originalInput;
        if (this$originalInput == null ? other$originalInput != null : !this$originalInput.equals(other$originalInput)) {
            return false;
        }
        List<ValidationError> this$validationErrors = this.validationErrors;
        List<ValidationError> other$validationErrors = other.validationErrors;
        if (this$validationErrors == null ? other$validationErrors != null : !((Object)this$validationErrors).equals(other$validationErrors)) {
            return false;
        }
        List<ExceptionTracker> this$children = this.children;
        List<ExceptionTracker> other$children = other.children;
        return !(this$children == null ? other$children != null : !((Object)this$children).equals(other$children));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        ValidationMappings $validationMappings = this.validationMappings;
        result = result * 59 + ($validationMappings == null ? 43 : ((Object)$validationMappings).hashCode());
        Universal $originalInput = this.originalInput;
        result = result * 59 + ($originalInput == null ? 43 : $originalInput.hashCode());
        List<ValidationError> $validationErrors = this.validationErrors;
        result = result * 59 + ($validationErrors == null ? 43 : ((Object)$validationErrors).hashCode());
        List<ExceptionTracker> $children = this.children;
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        return result;
    }

    @Generated
    private ExceptionTracker(TrackingPosition position, ValidationMappings validationMappings, Universal originalInput) {
        this.position = position;
        this.validationMappings = validationMappings;
        this.originalInput = originalInput;
    }
}

