/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.mapper.deserialization.validation;

import de.quantummaid.mapmaid.Collection;
import de.quantummaid.mapmaid.mapper.deserialization.validation.ExceptionMappingList;
import de.quantummaid.mapmaid.mapper.deserialization.validation.ExceptionMappingWithPropertyPath;
import de.quantummaid.mapmaid.mapper.deserialization.validation.ThrowableRelativesLookup;
import de.quantummaid.mapmaid.mapper.deserialization.validation.ValidationError;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

public final class ValidationMappings {
    private final Map<Class<? extends Throwable>, ExceptionMappingList<Throwable>> validationMappings;

    public static ValidationMappings empty() {
        return new ValidationMappings(Collection.smallMap());
    }

    public void putOneToOne(Class<? extends Throwable> exceptionType, ExceptionMappingWithPropertyPath<Throwable> mapping) {
        this.putAll(exceptionType, (throwable, propertyPath) -> List.of(mapping.map(throwable, propertyPath)));
    }

    public void putOneToMany(Class<? extends Throwable> exception, ExceptionMappingList<Throwable> mapping) {
        this.putAll(exception, mapping);
    }

    private void putAll(Class<? extends Throwable> exception, ExceptionMappingList<Throwable> mapping) {
        this.validationMappings.merge(exception, mapping, (a, b) -> (throwable, propertyPath) -> {
            List<ValidationError> map1 = a.map(throwable, propertyPath);
            List<ValidationError> map2 = b.map(throwable, propertyPath);
            ArrayList<ValidationError> map = new ArrayList<ValidationError>(map1.size() + map2.size());
            map.addAll(map1);
            map.addAll(map2);
            return map;
        });
    }

    public Optional<ExceptionMappingList<Throwable>> get(Class<? extends Throwable> throwable) {
        ExceptionMappingList<Throwable> mapping = this.validationMappings.get(throwable);
        if (mapping != null) {
            return Optional.of(mapping);
        }
        Set<Class<? extends Throwable>> assignableClasses = this.validationMappings.keySet().stream().filter(t -> t.isAssignableFrom(throwable)).collect(Collectors.toSet());
        ThrowableRelativesLookup lookup = ThrowableRelativesLookup.fromThrowable(throwable);
        Class<? extends Throwable> closestRelative = lookup.closestRelativeFrom(assignableClasses);
        return Optional.ofNullable(this.validationMappings.get(closestRelative));
    }

    @Generated
    public String toString() {
        return "ValidationMappings(validationMappings=" + this.validationMappings + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValidationMappings)) {
            return false;
        }
        ValidationMappings other = (ValidationMappings)o;
        Map<Class<? extends Throwable>, ExceptionMappingList<Throwable>> this$validationMappings = this.validationMappings;
        Map<Class<? extends Throwable>, ExceptionMappingList<Throwable>> other$validationMappings = other.validationMappings;
        return !(this$validationMappings == null ? other$validationMappings != null : !((Object)this$validationMappings).equals(other$validationMappings));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<Class<? extends Throwable>, ExceptionMappingList<Throwable>> $validationMappings = this.validationMappings;
        result = result * 59 + ($validationMappings == null ? 43 : ((Object)$validationMappings).hashCode());
        return result;
    }

    @Generated
    private ValidationMappings(Map<Class<? extends Throwable>, ExceptionMappingList<Throwable>> validationMappings) {
        this.validationMappings = validationMappings;
    }
}

