/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.shared.mapping;

import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import java.util.function.Function;
import lombok.Generated;

public final class Mapping {
    private final Class<?> from;
    private final Class<?> to;
    private final Function<Object, Object> mapping;

    public static <A, B> Mapping mapping(Class<A> from, Class<B> to, Function<A, B> mapping) {
        NotNullValidator.validateNotNull(from, "from");
        NotNullValidator.validateNotNull(to, "to");
        NotNullValidator.validateNotNull(mapping, "mapping");
        return new Mapping(from, to, mapping);
    }

    public Class<?> from() {
        return this.from;
    }

    public Class<?> to() {
        return this.to;
    }

    public <T> T map(Object from) {
        return (T)this.mapping.apply(from);
    }

    @Generated
    public String toString() {
        return "Mapping(from=" + this.from + ", to=" + this.to + ", mapping=" + this.mapping + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Mapping)) {
            return false;
        }
        Mapping other = (Mapping)o;
        Class<?> this$from = this.from;
        Class<?> other$from = other.from;
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        Class<?> this$to = this.to;
        Class<?> other$to = other.to;
        if (this$to == null ? other$to != null : !this$to.equals(other$to)) {
            return false;
        }
        Function<Object, Object> this$mapping = this.mapping;
        Function<Object, Object> other$mapping = other.mapping;
        return !(this$mapping == null ? other$mapping != null : !this$mapping.equals(other$mapping));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<?> $from = this.from;
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        Class<?> $to = this.to;
        result = result * 59 + ($to == null ? 43 : $to.hashCode());
        Function<Object, Object> $mapping = this.mapping;
        result = result * 59 + ($mapping == null ? 43 : $mapping.hashCode());
        return result;
    }

    @Generated
    private Mapping(Class<?> from, Class<?> to, Function<Object, Object> mapping) {
        this.from = from;
        this.to = to;
        this.mapping = mapping;
    }
}

