/*
 * Decompiled with CFR 0.152.
 */
package checkers.subtyping;

import checkers.basetype.BaseAnnotatedTypeFactory;
import checkers.basetype.BaseTypeChecker;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SubtypingAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    public SubtypingAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        this.postInit();
    }

    @Override
    protected Set<Class<? extends Annotation>> createSupportedTypeQualifiers() {
        String qualNames = this.checker.getOption("quals");
        if (qualNames == null) {
            this.checker.errorAbort("SubtypingChecker: missing required option: -Aquals");
        }
        HashSet qualSet = new HashSet();
        for (String qualName : qualNames.split(",")) {
            try {
                Class<?> q = Class.forName(qualName);
                qualSet.add(q);
            }
            catch (ClassNotFoundException e) {
                this.checker.errorAbort("SubtypingChecker: could not load class for qualifier: " + qualName + "; ensure that your classpath is correct.");
            }
        }
        return Collections.unmodifiableSet(qualSet);
    }
}

