/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.eventmaid.channel;

import de.quantummaid.eventmaid.channel.Channel;
import de.quantummaid.eventmaid.channel.ChannelImpl;
import de.quantummaid.eventmaid.channel.ChannelType;
import de.quantummaid.eventmaid.channel.action.Action;
import de.quantummaid.eventmaid.channel.action.ActionHandlerSet;
import de.quantummaid.eventmaid.channel.action.DefaultActionHandlerSet;
import de.quantummaid.eventmaid.channel.exception.ChannelExceptionHandler;
import de.quantummaid.eventmaid.channel.exception.ErrorThrowingChannelExceptionHandler;
import de.quantummaid.eventmaid.channel.internal.events.ChannelEventListener;
import de.quantummaid.eventmaid.channel.internal.events.SimpleChannelEventListener;
import de.quantummaid.eventmaid.channel.internal.statistics.ChannelStatisticsCollector;
import de.quantummaid.eventmaid.channel.internal.statistics.PipeStatisticsBasedChannelStatisticsCollector;
import de.quantummaid.eventmaid.configuration.AsynchronousConfiguration;
import de.quantummaid.eventmaid.internal.enforcing.NotNullEnforcer;
import de.quantummaid.eventmaid.internal.pipe.Pipe;
import de.quantummaid.eventmaid.internal.pipe.PipeBuilder;
import de.quantummaid.eventmaid.internal.pipe.PipeType;
import de.quantummaid.eventmaid.internal.pipe.exceptions.PipeErrorHandler;
import de.quantummaid.eventmaid.processingcontext.ProcessingContext;

public class ChannelBuilder<T> {
    private Action<T> action;
    private ActionHandlerSet<T> actionHandlerSet;
    private ChannelEventListener<ProcessingContext<T>> eventListener;
    private ChannelStatisticsCollector statisticsCollector;
    private ChannelExceptionHandler<T> channelExceptionHandler = ErrorThrowingChannelExceptionHandler.errorThrowingChannelExceptionHandler();
    private ChannelType type = ChannelType.SYNCHRONOUS;
    private AsynchronousConfiguration asynchronousConfiguration;

    public static <T> Channel<T> aChannelWithDefaultAction(Action<T> defaultAction) {
        return new ChannelBuilder<T>().withDefaultAction(defaultAction).build();
    }

    public static <T> ChannelBuilder<T> aChannel() {
        return new ChannelBuilder<T>();
    }

    public static <T> ChannelBuilder<T> aChannel(Class<T> channelTypeClass) {
        return new ChannelBuilder<T>();
    }

    public ChannelBuilder<T> forType(ChannelType type) {
        this.type = type;
        return this;
    }

    public ChannelBuilder<T> withAsynchronousConfiguration(AsynchronousConfiguration configuration) {
        this.asynchronousConfiguration = configuration;
        return this;
    }

    public ChannelBuilder<T> withDefaultAction(Action<T> action) {
        this.action = action;
        return this;
    }

    public ChannelBuilder<T> withChannelExceptionHandler(ChannelExceptionHandler<T> channelExceptionHandler) {
        this.channelExceptionHandler = channelExceptionHandler;
        return this;
    }

    public ChannelBuilder<T> withActionHandlerSet(ActionHandlerSet<T> actionHandlerSet) {
        this.actionHandlerSet = actionHandlerSet;
        return this;
    }

    public Channel<T> build() {
        NotNullEnforcer.ensureNotNull(this.action, "action");
        Pipe<ProcessingContext<T>> acceptingPipe = null;
        try {
            acceptingPipe = this.createAcceptingPipe();
            Pipe<ProcessingContext<T>> prePipe = this.createSynchronousPipe();
            Pipe<ProcessingContext<T>> processPipe = this.createSynchronousPipe();
            Pipe<ProcessingContext<T>> postPipe = this.createDeliveringPipe();
            this.createStatisticsCollectorAndEventListenerSetup(acceptingPipe, postPipe);
            ActionHandlerSet<T> createdActionHandlerSet = this.createDefaultActionHandlerSetIfAbsent();
            return ChannelImpl.channel(this.action, acceptingPipe, prePipe, processPipe, postPipe, this.eventListener, this.statisticsCollector, createdActionHandlerSet, this.channelExceptionHandler);
        }
        catch (RuntimeException e) {
            if (acceptingPipe != null) {
                acceptingPipe.close();
            }
            throw e;
        }
    }

    private Pipe<ProcessingContext<T>> createAcceptingPipe() {
        switch (this.type) {
            case SYNCHRONOUS: {
                return this.createSynchronousPipe();
            }
            case ASYNCHRONOUS: {
                return PipeBuilder.aPipe().ofType(PipeType.ASYNCHRONOUS).withAsynchronousConfiguration(this.asynchronousConfiguration).build();
            }
        }
        throw new IllegalArgumentException("Unsupported channel type: " + this.type);
    }

    private Pipe<ProcessingContext<T>> createSynchronousPipe() {
        PipeBuilder pipeBuilder = PipeBuilder.aPipe();
        return pipeBuilder.ofType(PipeType.SYNCHRONOUS).build();
    }

    private Pipe<ProcessingContext<T>> createDeliveringPipe() {
        return PipeBuilder.aPipe().ofType(PipeType.SYNCHRONOUS).withErrorHandler(new PipeErrorHandler<ProcessingContext<T>>(){

            @Override
            public boolean shouldErrorBeHandledAndDeliveryAborted(ProcessingContext<T> m3, Exception e) {
                return ChannelBuilder.this.channelExceptionHandler.shouldSubscriberErrorBeHandledAndDeliveryAborted(m3, e);
            }

            @Override
            public void handleException(ProcessingContext<T> message, Exception e) {
                ChannelBuilder.this.channelExceptionHandler.handleSubscriberException(message, e);
            }
        }).build();
    }

    private void createStatisticsCollectorAndEventListenerSetup(Pipe<ProcessingContext<T>> acceptingPipe, Pipe<ProcessingContext<T>> postPipe) {
        if (this.eventListener == null && this.statisticsCollector == null) {
            PipeStatisticsBasedChannelStatisticsCollector createdStatisticsCollector = PipeStatisticsBasedChannelStatisticsCollector.pipeStatisticsBasedChannelStatisticsCollector(acceptingPipe, postPipe);
            this.statisticsCollector = createdStatisticsCollector;
            this.eventListener = SimpleChannelEventListener.simpleChannelEventListener(createdStatisticsCollector);
        }
    }

    private ActionHandlerSet<T> createDefaultActionHandlerSetIfAbsent() {
        if (this.actionHandlerSet != null) {
            return this.actionHandlerSet;
        }
        return DefaultActionHandlerSet.defaultActionHandlerSet();
    }
}

