/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.eventmaid.messagebus;

import de.quantummaid.eventmaid.filtering.Filter;
import de.quantummaid.eventmaid.identification.CorrelationId;
import de.quantummaid.eventmaid.identification.MessageId;
import de.quantummaid.eventmaid.internal.autoclosable.NoErrorAutoClosable;
import de.quantummaid.eventmaid.messagebus.MessageBusStatusInformation;
import de.quantummaid.eventmaid.messagebus.exception.MessageBusExceptionListener;
import de.quantummaid.eventmaid.processingcontext.EventType;
import de.quantummaid.eventmaid.processingcontext.ProcessingContext;
import de.quantummaid.eventmaid.subscribing.Subscriber;
import de.quantummaid.eventmaid.subscribing.SubscriptionId;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public interface MessageBus
extends NoErrorAutoClosable {
    public MessageId send(EventType var1, Object var2);

    public MessageId send(EventType var1, Object var2, CorrelationId var3);

    public MessageId send(ProcessingContext<Object> var1);

    public SubscriptionId subscribe(EventType var1, Consumer<Object> var2);

    public SubscriptionId subscribe(EventType var1, Subscriber<Object> var2);

    public SubscriptionId subscribe(CorrelationId var1, Consumer<ProcessingContext<Object>> var2);

    public SubscriptionId subscribe(CorrelationId var1, Subscriber<ProcessingContext<Object>> var2);

    public SubscriptionId subscribeRaw(EventType var1, Consumer<ProcessingContext<Object>> var2);

    public SubscriptionId subscribeRaw(EventType var1, Subscriber<ProcessingContext<Object>> var2);

    public void unsubcribe(SubscriptionId var1);

    public void add(Filter<Object> var1);

    public void add(Filter<Object> var1, int var2);

    public void addRaw(Filter<ProcessingContext<Object>> var1);

    public void addRaw(Filter<ProcessingContext<Object>> var1, int var2);

    public List<Filter<Object>> getFilter();

    public void remove(Filter<Object> var1);

    public SubscriptionId onException(EventType var1, MessageBusExceptionListener var2);

    public SubscriptionId onException(CorrelationId var1, MessageBusExceptionListener var2);

    public void unregisterExceptionListener(SubscriptionId var1);

    public MessageBusStatusInformation getStatusInformation();

    public void close(boolean var1);

    public boolean awaitTermination(long var1, TimeUnit var3) throws InterruptedException;

    public boolean isClosed();
}

