/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.endpoint;

import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.MetaDataKey;
import de.quantummaid.httpmaid.endpoint.RawRequestBuilder;
import de.quantummaid.httpmaid.util.Validators;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public final class RawRequest {
    private final String path;
    private final String requestMethod;
    private final Map<String, List<String>> headers;
    private final Map<String, String> queryParameters;
    private final InputStream body;
    private final Map<MetaDataKey<?>, Object> additionalMetaData;

    public static RawRequestBuilder rawRequestBuilder() {
        return RawRequestBuilder.rawRequestBuilder();
    }

    public static RawRequest rawRequest(String path, String requestMethod, Map<String, List<String>> headers, Map<String, String> queryParameters, InputStream body, Map<MetaDataKey<?>, Object> additionalMetaData) {
        Validators.validateNotNull(path, "path");
        Validators.validateNotNull(requestMethod, "requestMethod");
        Validators.validateNotNull(headers, "headers");
        Validators.validateNotNull(queryParameters, "queryParameters");
        Validators.validateNotNull(body, "body");
        return new RawRequest(path, requestMethod, headers, queryParameters, body, additionalMetaData);
    }

    public void enter(MetaData metaData) {
        metaData.set(HttpMaidChainKeys.RAW_PATH, this.path);
        metaData.set(HttpMaidChainKeys.RAW_METHOD, this.requestMethod);
        metaData.set(HttpMaidChainKeys.RAW_REQUEST_HEADERS, this.headers);
        metaData.set(HttpMaidChainKeys.RAW_REQUEST_QUERY_PARAMETERS, this.queryParameters);
        metaData.set(HttpMaidChainKeys.REQUEST_BODY_STREAM, this.body);
        metaData.set(HttpMaidChainKeys.IS_HTTP_REQUEST, true);
        this.additionalMetaData.forEach(metaData::setUnchecked);
    }

    @Generated
    public String toString() {
        return "RawRequest(path=" + this.path + ", requestMethod=" + this.requestMethod + ", headers=" + this.headers + ", queryParameters=" + this.queryParameters + ", body=" + this.body + ", additionalMetaData=" + this.additionalMetaData + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawRequest)) {
            return false;
        }
        RawRequest other = (RawRequest)o;
        String this$path = this.path;
        String other$path = other.path;
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$requestMethod = this.requestMethod;
        String other$requestMethod = other.requestMethod;
        if (this$requestMethod == null ? other$requestMethod != null : !this$requestMethod.equals(other$requestMethod)) {
            return false;
        }
        Map<String, List<String>> this$headers = this.headers;
        Map<String, List<String>> other$headers = other.headers;
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        Map<String, String> this$queryParameters = this.queryParameters;
        Map<String, String> other$queryParameters = other.queryParameters;
        if (this$queryParameters == null ? other$queryParameters != null : !((Object)this$queryParameters).equals(other$queryParameters)) {
            return false;
        }
        InputStream this$body = this.body;
        InputStream other$body = other.body;
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        Map<MetaDataKey<?>, Object> this$additionalMetaData = this.additionalMetaData;
        Map<MetaDataKey<?>, Object> other$additionalMetaData = other.additionalMetaData;
        return !(this$additionalMetaData == null ? other$additionalMetaData != null : !((Object)this$additionalMetaData).equals(other$additionalMetaData));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $path = this.path;
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $requestMethod = this.requestMethod;
        result = result * 59 + ($requestMethod == null ? 43 : $requestMethod.hashCode());
        Map<String, List<String>> $headers = this.headers;
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        Map<String, String> $queryParameters = this.queryParameters;
        result = result * 59 + ($queryParameters == null ? 43 : ((Object)$queryParameters).hashCode());
        InputStream $body = this.body;
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        Map<MetaDataKey<?>, Object> $additionalMetaData = this.additionalMetaData;
        result = result * 59 + ($additionalMetaData == null ? 43 : ((Object)$additionalMetaData).hashCode());
        return result;
    }

    @Generated
    private RawRequest(String path, String requestMethod, Map<String, List<String>> headers, Map<String, String> queryParameters, InputStream body, Map<MetaDataKey<?>, Object> additionalMetaData) {
        this.path = path;
        this.requestMethod = requestMethod;
        this.headers = headers;
        this.queryParameters = queryParameters;
        this.body = body;
        this.additionalMetaData = additionalMetaData;
    }
}

