/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.path.statemachine;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public final class MatchingResult {
    private final boolean successful;
    private final Map<String, String> captures;

    public static MatchingResult matchingResult(boolean successful) {
        return new MatchingResult(successful, new HashMap<String, String>());
    }

    public MatchingResult merge(Map<String, String> otherCaptures) {
        HashMap<String, String> mergedCaptures = new HashMap<String, String>(this.captures);
        mergedCaptures.putAll(otherCaptures);
        return new MatchingResult(true, mergedCaptures);
    }

    public static MatchingResult success(Map<String, String> captures) {
        return new MatchingResult(true, captures);
    }

    public static MatchingResult fail() {
        return new MatchingResult(false, new HashMap<String, String>());
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public Map<String, String> captures() {
        return this.captures;
    }

    @Generated
    public String toString() {
        return "MatchingResult(successful=" + this.isSuccessful() + ", captures=" + this.captures + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MatchingResult)) {
            return false;
        }
        MatchingResult other = (MatchingResult)o;
        if (this.isSuccessful() != other.isSuccessful()) {
            return false;
        }
        Map<String, String> this$captures = this.captures;
        Map<String, String> other$captures = other.captures;
        return !(this$captures == null ? other$captures != null : !((Object)this$captures).equals(other$captures));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccessful() ? 79 : 97);
        Map<String, String> $captures = this.captures;
        result = result * 59 + ($captures == null ? 43 : ((Object)$captures).hashCode());
        return result;
    }

    @Generated
    private MatchingResult(boolean successful, Map<String, String> captures) {
        this.successful = successful;
        this.captures = captures;
    }
}

