/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.security.authentication;

import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.Processor;
import de.quantummaid.httpmaid.handler.http.HttpRequest;
import de.quantummaid.httpmaid.security.Filter;
import de.quantummaid.httpmaid.security.authentication.Authenticator;
import de.quantummaid.httpmaid.security.authentication.AuthenticatorId;
import de.quantummaid.httpmaid.security.authentication.CouldNotAuthenticateException;
import de.quantummaid.httpmaid.util.Validators;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public final class AuthenticatorProcessor
implements Processor {
    private final Authenticator<MetaData> authenticator;
    private final AuthenticatorId authenticatorId;
    private final List<Filter> optionalRequests;

    public static AuthenticatorProcessor authenticatorProcessor(Authenticator<MetaData> authenticator, AuthenticatorId authenticatorId, List<Filter> optionalRequests) {
        Validators.validateNotNull(authenticator, "authenticator");
        Validators.validateNotNull(authenticatorId, "authenticatorId");
        Validators.validateNotNull(optionalRequests, "optionalRequests");
        return new AuthenticatorProcessor(authenticator, authenticatorId, optionalRequests);
    }

    @Override
    public void apply(MetaData metaData) {
        Optional<?> authenticationInformation = this.authenticator.authenticate(metaData);
        if (authenticationInformation.isEmpty()) {
            this.failIfNotOptional(metaData);
        } else {
            authenticationInformation.ifPresent(information -> metaData.set(HttpMaidChainKeys.AUTHENTICATION_INFORMATION, information));
        }
    }

    private void failIfNotOptional(MetaData metaData) {
        HttpRequest request = HttpRequest.httpRequest(metaData);
        if (this.optionalRequests.stream().noneMatch(filter -> filter.filter(request))) {
            throw CouldNotAuthenticateException.couldNotAuthenticateException(metaData, this.authenticatorId);
        }
    }

    @Generated
    public String toString() {
        return "AuthenticatorProcessor(authenticator=" + this.authenticator + ", authenticatorId=" + this.authenticatorId + ", optionalRequests=" + this.optionalRequests + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthenticatorProcessor)) {
            return false;
        }
        AuthenticatorProcessor other = (AuthenticatorProcessor)o;
        Authenticator<MetaData> this$authenticator = this.authenticator;
        Authenticator<MetaData> other$authenticator = other.authenticator;
        if (this$authenticator == null ? other$authenticator != null : !this$authenticator.equals(other$authenticator)) {
            return false;
        }
        AuthenticatorId this$authenticatorId = this.authenticatorId;
        AuthenticatorId other$authenticatorId = other.authenticatorId;
        if (this$authenticatorId == null ? other$authenticatorId != null : !((Object)this$authenticatorId).equals(other$authenticatorId)) {
            return false;
        }
        List<Filter> this$optionalRequests = this.optionalRequests;
        List<Filter> other$optionalRequests = other.optionalRequests;
        return !(this$optionalRequests == null ? other$optionalRequests != null : !((Object)this$optionalRequests).equals(other$optionalRequests));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Authenticator<MetaData> $authenticator = this.authenticator;
        result = result * 59 + ($authenticator == null ? 43 : $authenticator.hashCode());
        AuthenticatorId $authenticatorId = this.authenticatorId;
        result = result * 59 + ($authenticatorId == null ? 43 : ((Object)$authenticatorId).hashCode());
        List<Filter> $optionalRequests = this.optionalRequests;
        result = result * 59 + ($optionalRequests == null ? 43 : ((Object)$optionalRequests).hashCode());
        return result;
    }

    @Generated
    private AuthenticatorProcessor(Authenticator<MetaData> authenticator, AuthenticatorId authenticatorId, List<Filter> optionalRequests) {
        this.authenticator = authenticator;
        this.authenticatorId = authenticatorId;
        this.optionalRequests = optionalRequests;
    }
}

