/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid;

import de.quantummaid.mapmaid.builder.MapMaidBuilder;
import de.quantummaid.mapmaid.debug.DebugInformation;
import de.quantummaid.mapmaid.mapper.deserialization.Deserializer;
import de.quantummaid.mapmaid.mapper.injector.InjectorLambda;
import de.quantummaid.mapmaid.mapper.marshalling.MarshallingType;
import de.quantummaid.mapmaid.mapper.serialization.Serializer;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import de.quantummaid.reflectmaid.GenericType;
import lombok.Generated;

public final class MapMaid {
    private final Serializer serializer;
    private final Deserializer deserializer;
    private final DebugInformation debugInformation;

    public static MapMaidBuilder aMapMaid() {
        return MapMaidBuilder.mapMaidBuilder();
    }

    public static MapMaid mapMaid(Serializer serializer, Deserializer deserializer, DebugInformation debugInformation) {
        return new MapMaid(serializer, deserializer, debugInformation);
    }

    public Serializer serializer() {
        return this.serializer;
    }

    public Deserializer deserializer() {
        return this.deserializer;
    }

    public String serializeToJson(Object object) {
        NotNullValidator.validateNotNull(object, "object");
        Class<?> type = object.getClass();
        return this.serializeToJson(object, type);
    }

    public String serializeToJson(Object object, Class<?> type) {
        GenericType<?> genericType = GenericType.genericType(type);
        return this.serializeToJson(object, genericType);
    }

    public String serializeToJson(Object object, GenericType<?> type) {
        TypeIdentifier typeIdentifier = TypeIdentifier.typeIdentifierFor(type);
        return this.serializeToJson(object, typeIdentifier);
    }

    public String serializeToJson(Object object, TypeIdentifier type) {
        return this.serializeTo(object, MarshallingType.JSON, type);
    }

    public String serializeToYaml(Object object) {
        NotNullValidator.validateNotNull(object, "object");
        Class<?> type = object.getClass();
        return this.serializeToYaml(object, type);
    }

    public String serializeToYaml(Object object, Class<?> type) {
        GenericType<?> genericType = GenericType.genericType(type);
        return this.serializeToYaml(object, genericType);
    }

    public String serializeToYaml(Object object, GenericType<?> type) {
        TypeIdentifier typeIdentifier = TypeIdentifier.typeIdentifierFor(type);
        return this.serializeToYaml(object, typeIdentifier);
    }

    public String serializeToYaml(Object object, TypeIdentifier type) {
        return this.serializeTo(object, MarshallingType.YAML, type);
    }

    public String serializeToXml(Object object) {
        NotNullValidator.validateNotNull(object, "object");
        Class<?> type = object.getClass();
        return this.serializeToXml(object, type);
    }

    public String serializeToXml(Object object, Class<?> type) {
        GenericType<?> genericType = GenericType.genericType(type);
        return this.serializeToXml(object, genericType);
    }

    public String serializeToXml(Object object, GenericType<?> type) {
        TypeIdentifier typeIdentifier = TypeIdentifier.typeIdentifierFor(type);
        return this.serializeToXml(object, typeIdentifier);
    }

    public String serializeToXml(Object object, TypeIdentifier type) {
        return this.serializeTo(object, MarshallingType.XML, type);
    }

    public String serializeTo(Object object, MarshallingType marshallingType) {
        NotNullValidator.validateNotNull(object, "object");
        Class<?> type = object.getClass();
        return this.serializeTo(object, marshallingType, type);
    }

    public String serializeTo(Object object, MarshallingType marshallingType, Class<?> type) {
        GenericType<?> genericType = GenericType.genericType(type);
        return this.serializeTo(object, marshallingType, genericType);
    }

    public String serializeTo(Object object, MarshallingType marshallingType, GenericType<?> type) {
        TypeIdentifier typeIdentifier = TypeIdentifier.typeIdentifierFor(type);
        return this.serializeTo(object, marshallingType, typeIdentifier);
    }

    public String serializeTo(Object object, MarshallingType marshallingType, TypeIdentifier type) {
        return this.serializer.serialize(object, type, marshallingType, input -> input);
    }

    public <T> T deserializeJson(String json, Class<T> targetType) {
        GenericType<T> genericType = GenericType.genericType(targetType);
        return this.deserializeJson(json, genericType);
    }

    public <T> T deserializeJson(String json, GenericType<T> targetType) {
        TypeIdentifier typeIdentifier = TypeIdentifier.typeIdentifierFor(targetType);
        return this.deserializeJson(json, typeIdentifier);
    }

    public <T> T deserializeJson(String json, TypeIdentifier targetType) {
        return this.deserializeJson(json, targetType, InjectorLambda.noop());
    }

    public <T> T deserializeJson(String json, Class<T> targetType, InjectorLambda injector) {
        GenericType<T> genericType = GenericType.genericType(targetType);
        return this.deserializeJson(json, genericType, injector);
    }

    public <T> T deserializeJson(String json, GenericType<T> targetType, InjectorLambda injector) {
        TypeIdentifier typeIdentifier = TypeIdentifier.typeIdentifierFor(targetType);
        return this.deserializeJson(json, typeIdentifier, injector);
    }

    public <T> T deserializeJson(String json, TypeIdentifier targetType, InjectorLambda injector) {
        return this.deserialize(json, targetType, MarshallingType.JSON, injector);
    }

    public <T> T deserializeYaml(String yaml, Class<T> targetType) {
        GenericType<T> genericType = GenericType.genericType(targetType);
        return this.deserializeYaml(yaml, genericType);
    }

    public <T> T deserializeYaml(String yaml, GenericType<T> targetType) {
        TypeIdentifier typeIdentifier = TypeIdentifier.typeIdentifierFor(targetType);
        return this.deserializeYaml(yaml, typeIdentifier);
    }

    public <T> T deserializeYaml(String yaml, TypeIdentifier targetType) {
        return this.deserializeYaml(yaml, targetType, InjectorLambda.noop());
    }

    public <T> T deserializeYaml(String yaml, Class<T> targetType, InjectorLambda injector) {
        GenericType<T> genericType = GenericType.genericType(targetType);
        return this.deserializeYaml(yaml, genericType, injector);
    }

    public <T> T deserializeYaml(String yaml, GenericType<T> targetType, InjectorLambda injector) {
        TypeIdentifier typeIdentifier = TypeIdentifier.typeIdentifierFor(targetType);
        return this.deserializeYaml(yaml, typeIdentifier, injector);
    }

    public <T> T deserializeYaml(String yaml, TypeIdentifier targetType, InjectorLambda injector) {
        return this.deserialize(yaml, targetType, MarshallingType.YAML, injector);
    }

    public <T> T deserializeXml(String xml, Class<T> targetType) {
        GenericType<T> genericType = GenericType.genericType(targetType);
        return this.deserializeXml(xml, genericType);
    }

    public <T> T deserializeXml(String xml, GenericType<T> targetType) {
        TypeIdentifier typeIdentifier = TypeIdentifier.typeIdentifierFor(targetType);
        return this.deserializeXml(xml, typeIdentifier);
    }

    public <T> T deserializeXml(String xml, TypeIdentifier targetType) {
        return this.deserializeXml(xml, targetType, InjectorLambda.noop());
    }

    public <T> T deserializeXml(String xml, Class<T> targetType, InjectorLambda injector) {
        GenericType<T> genericType = GenericType.genericType(targetType);
        return this.deserializeXml(xml, genericType, injector);
    }

    public <T> T deserializeXml(String xml, GenericType<T> targetType, InjectorLambda injector) {
        TypeIdentifier typeIdentifier = TypeIdentifier.typeIdentifierFor(targetType);
        return this.deserializeXml(xml, typeIdentifier, injector);
    }

    public <T> T deserializeXml(String xml, TypeIdentifier targetType, InjectorLambda injector) {
        return this.deserialize(xml, targetType, MarshallingType.XML, injector);
    }

    public <T> T deserialize(String input, Class<T> targetType, MarshallingType marshallingType) {
        GenericType<T> genericType = GenericType.genericType(targetType);
        return this.deserialize(input, genericType, marshallingType);
    }

    public <T> T deserialize(String input, GenericType<T> targetType, MarshallingType marshallingType) {
        TypeIdentifier typeIdentifier = TypeIdentifier.typeIdentifierFor(targetType);
        return this.deserialize(input, typeIdentifier, marshallingType);
    }

    public <T> T deserialize(String input, TypeIdentifier targetType, MarshallingType marshallingType) {
        return this.deserialize(input, targetType, marshallingType, InjectorLambda.noop());
    }

    public <T> T deserialize(String input, Class<T> targetType, MarshallingType marshallingType, InjectorLambda injector) {
        GenericType<T> genericType = GenericType.genericType(targetType);
        return this.deserialize(input, genericType, marshallingType, injector);
    }

    public <T> T deserialize(String input, GenericType<T> targetType, MarshallingType marshallingType, InjectorLambda injector) {
        TypeIdentifier typeIdentifier = TypeIdentifier.typeIdentifierFor(targetType);
        return this.deserialize(input, typeIdentifier, marshallingType, injector);
    }

    public <T> T deserialize(String input, TypeIdentifier targetType, MarshallingType marshallingType, InjectorLambda injector) {
        return (T)this.deserializer.deserialize(input, targetType, marshallingType, injector);
    }

    public DebugInformation debugInformation() {
        return this.debugInformation;
    }

    @Generated
    public String toString() {
        return "MapMaid(serializer=" + this.serializer + ", deserializer=" + this.deserializer + ", debugInformation=" + this.debugInformation + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapMaid)) {
            return false;
        }
        MapMaid other = (MapMaid)o;
        Serializer this$serializer = this.serializer;
        Serializer other$serializer = other.serializer;
        if (this$serializer == null ? other$serializer != null : !((Object)this$serializer).equals(other$serializer)) {
            return false;
        }
        Deserializer this$deserializer = this.deserializer;
        Deserializer other$deserializer = other.deserializer;
        if (this$deserializer == null ? other$deserializer != null : !((Object)this$deserializer).equals(other$deserializer)) {
            return false;
        }
        DebugInformation this$debugInformation = this.debugInformation;
        DebugInformation other$debugInformation = other.debugInformation;
        return !(this$debugInformation == null ? other$debugInformation != null : !((Object)this$debugInformation).equals(other$debugInformation));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Serializer $serializer = this.serializer;
        result = result * 59 + ($serializer == null ? 43 : ((Object)$serializer).hashCode());
        Deserializer $deserializer = this.deserializer;
        result = result * 59 + ($deserializer == null ? 43 : ((Object)$deserializer).hashCode());
        DebugInformation $debugInformation = this.debugInformation;
        result = result * 59 + ($debugInformation == null ? 43 : ((Object)$debugInformation).hashCode());
        return result;
    }

    @Generated
    private MapMaid(Serializer serializer, Deserializer deserializer, DebugInformation debugInformation) {
        this.serializer = serializer;
        this.deserializer = deserializer;
        this.debugInformation = debugInformation;
    }
}

