/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.autoload;

import de.quantummaid.mapmaid.builder.MarshallerAndUnmarshaller;
import de.quantummaid.mapmaid.builder.autoload.AutoloadingException;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Optional;

public final class Autoloader {
    private Autoloader() {
    }

    public static <T> Optional<T> autoload(String fullyQualifiedClassName) {
        NotNullValidator.validateNotNull(fullyQualifiedClassName, "fullyQualifiedClassName");
        return Autoloader.loadClass(fullyQualifiedClassName).map(clazz -> {
            Method staticInitializer = Autoloader.findStaticInitializer(clazz);
            return Autoloader.invoke(staticInitializer);
        });
    }

    private static Optional<Class<?>> loadClass(String fullyQualifiedClassName) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clazz = classLoader.loadClass(fullyQualifiedClassName);
            return Optional.of(clazz);
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }

    private static Method findStaticInitializer(Class<?> clazz) {
        Method[] methods = clazz.getMethods();
        return Arrays.stream(methods).filter(method -> Modifier.isPublic(method.getModifiers())).filter(method -> Modifier.isStatic(method.getModifiers())).filter(method -> method.getReturnType().equals(clazz)).filter(method -> method.getParameterCount() == 0).findFirst().orElseThrow(() -> new UnsupportedOperationException(String.format("class '%s' needs a public static zero-parameter initializer to be autoloadable", clazz)));
    }

    private static MarshallerAndUnmarshaller invoke(Method staticInitializer) {
        try {
            return (MarshallerAndUnmarshaller)staticInitializer.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw AutoloadingException.autoloadingException(e);
        }
    }
}

