/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.customtypes.serializedobject;

import de.quantummaid.mapmaid.Collection;
import de.quantummaid.mapmaid.builder.customtypes.serializedobject.CustomDeserializationField;
import de.quantummaid.mapmaid.builder.customtypes.serializedobject.CustomDeserializer;
import de.quantummaid.mapmaid.builder.customtypes.serializedobject.CustomSerializationField;
import de.quantummaid.mapmaid.builder.customtypes.serializedobject.InvocableDeserializer;
import de.quantummaid.mapmaid.builder.customtypes.serializedobject.Query;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.TypeDeserializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.TypeSerializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.serializedobject.SerializationField;
import de.quantummaid.mapmaid.mapper.serialization.serializers.serializedobject.SerializationFields;
import de.quantummaid.mapmaid.mapper.serialization.serializers.serializedobject.SerializedObjectSerializer;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import de.quantummaid.reflectmaid.GenericType;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public final class Builder {
    private final TypeIdentifier type;
    private final List<CustomDeserializationField> deserializationFields;
    private final List<CustomSerializationField> serializationFields;
    private InvocableDeserializer<?> deserializer;

    public static Builder emptyBuilder(TypeIdentifier type) {
        return new Builder(type, Collection.smallList(), Collection.smallList());
    }

    public void addDuplexField(GenericType<?> type, String name, Query<Object, Object> query) {
        this.addDeserializationField(type, name);
        this.addSerializationField(type, name, query);
    }

    public void addDeserializationField(GenericType<?> type, String name) {
        NotNullValidator.validateNotNull(type, "type");
        NotNullValidator.validateNotNull(name, "name");
        CustomDeserializationField deserializationField = CustomDeserializationField.deserializationField(type, name);
        this.deserializationFields.add(deserializationField);
    }

    public void addSerializationField(GenericType<?> type, String name, Query<Object, Object> query) {
        NotNullValidator.validateNotNull(type, "type");
        NotNullValidator.validateNotNull(name, "name");
        CustomSerializationField serializationField = CustomSerializationField.serializationField(type, name, query);
        this.serializationFields.add(serializationField);
    }

    public void setDeserializer(InvocableDeserializer<?> deserializer) {
        NotNullValidator.validateNotNull(deserializer, "deserializer");
        this.deserializer = deserializer;
    }

    public TypeIdentifier getType() {
        return this.type;
    }

    public TypeDeserializer createDeserializer() {
        return CustomDeserializer.userProvidedDeserializer(this.deserializer, this.deserializationFields);
    }

    public TypeSerializer createSerializer() {
        List<SerializationField> serializationFieldList = this.serializationFields.stream().map(field -> SerializationField.serializationField(field.type(), field.name(), field::query)).collect(Collectors.toList());
        SerializationFields fields = SerializationFields.serializationFields(serializationFieldList);
        return SerializedObjectSerializer.serializedObjectSerializer(fields);
    }

    @Generated
    public String toString() {
        return "Builder(type=" + this.getType() + ", deserializationFields=" + this.deserializationFields + ", serializationFields=" + this.serializationFields + ", deserializer=" + this.deserializer + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Builder)) {
            return false;
        }
        Builder other = (Builder)o;
        TypeIdentifier this$type = this.getType();
        TypeIdentifier other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        List<CustomDeserializationField> this$deserializationFields = this.deserializationFields;
        List<CustomDeserializationField> other$deserializationFields = other.deserializationFields;
        if (this$deserializationFields == null ? other$deserializationFields != null : !((Object)this$deserializationFields).equals(other$deserializationFields)) {
            return false;
        }
        List<CustomSerializationField> this$serializationFields = this.serializationFields;
        List<CustomSerializationField> other$serializationFields = other.serializationFields;
        if (this$serializationFields == null ? other$serializationFields != null : !((Object)this$serializationFields).equals(other$serializationFields)) {
            return false;
        }
        InvocableDeserializer<?> this$deserializer = this.deserializer;
        InvocableDeserializer<?> other$deserializer = other.deserializer;
        return !(this$deserializer == null ? other$deserializer != null : !this$deserializer.equals(other$deserializer));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TypeIdentifier $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        List<CustomDeserializationField> $deserializationFields = this.deserializationFields;
        result = result * 59 + ($deserializationFields == null ? 43 : ((Object)$deserializationFields).hashCode());
        List<CustomSerializationField> $serializationFields = this.serializationFields;
        result = result * 59 + ($serializationFields == null ? 43 : ((Object)$serializationFields).hashCode());
        InvocableDeserializer<?> $deserializer = this.deserializer;
        result = result * 59 + ($deserializer == null ? 43 : $deserializer.hashCode());
        return result;
    }

    @Generated
    private Builder(TypeIdentifier type, List<CustomDeserializationField> deserializationFields, List<CustomSerializationField> serializationFields) {
        this.type = type;
        this.deserializationFields = deserializationFields;
        this.serializationFields = serializationFields;
    }
}

