/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.detection;

import de.quantummaid.mapmaid.builder.RequiredCapabilities;
import de.quantummaid.mapmaid.builder.detection.DetectionResult;
import de.quantummaid.mapmaid.builder.detection.customprimitive.deserialization.CustomPrimitiveDeserializationDetector;
import de.quantummaid.mapmaid.builder.detection.customprimitive.serialization.CustomPrimitiveSerializationDetector;
import de.quantummaid.mapmaid.builder.detection.serializedobject.SerializationFieldOptions;
import de.quantummaid.mapmaid.builder.detection.serializedobject.deserialization.SerializedObjectDeserializationDetector;
import de.quantummaid.mapmaid.builder.detection.serializedobject.fields.FieldDetector;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.DisambiguationResult;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.Disambiguator;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.Disambiguators;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.SerializersAndDeserializers;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.symmetry.serializedobject.SerializedObjectOptions;
import de.quantummaid.mapmaid.debug.ScanInformationBuilder;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.TypeDeserializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.TypeSerializer;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import de.quantummaid.reflectmaid.ResolvedType;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public final class SimpleDetector {
    private final List<FieldDetector> fieldDetectors;
    private final List<SerializedObjectDeserializationDetector> serializedObjectDeserializationDetectors;
    private final List<CustomPrimitiveSerializationDetector> customPrimitiveSerializationDetectors;
    private final List<CustomPrimitiveDeserializationDetector> customPrimitiveDeserializationDetectors;

    public static SimpleDetector detector(List<FieldDetector> fieldDetectors, List<SerializedObjectDeserializationDetector> serializedObjectDeserializationDetectors, List<CustomPrimitiveSerializationDetector> customPrimitiveSerializationDetectors, List<CustomPrimitiveDeserializationDetector> customPrimitiveDeserializationDetectors) {
        NotNullValidator.validateNotNull(fieldDetectors, "fieldDetectors");
        NotNullValidator.validateNotNull(serializedObjectDeserializationDetectors, "serializedObjectDeserializationDetectors");
        NotNullValidator.validateNotNull(customPrimitiveSerializationDetectors, "customPrimitiveSerializationDetectors");
        NotNullValidator.validateNotNull(customPrimitiveDeserializationDetectors, "customPrimitiveDeserializationDetectors");
        return new SimpleDetector(fieldDetectors, serializedObjectDeserializationDetectors, customPrimitiveSerializationDetectors, customPrimitiveDeserializationDetectors);
    }

    public DetectionResult<DisambiguationResult> detect(TypeIdentifier typeIdentifier, ScanInformationBuilder scanInformationBuilder, RequiredCapabilities capabilities, Disambiguators disambiguators, List<TypeIdentifier> injectedTypes) {
        List<TypeDeserializer> customPrimitiveDeserializers;
        List<TypeDeserializer> serializedObjectDeserializers;
        SerializationFieldOptions serializationFieldOptions;
        List<TypeSerializer> customPrimitiveSerializers;
        if (typeIdentifier.isVirtual()) {
            return DetectionResult.failure("can only detect real types");
        }
        ResolvedType type = typeIdentifier.getRealType();
        Optional<DetectionResult<DisambiguationResult>> isNotSupported = SimpleDetector.validateForSupportedFeatures(type);
        if (isNotSupported.isPresent()) {
            return isNotSupported.get();
        }
        scanInformationBuilder.resetScan();
        if (capabilities.hasSerialization()) {
            customPrimitiveSerializers = this.detectCustomPrimitiveSerializers(type);
            customPrimitiveSerializers.forEach(scanInformationBuilder::addSerializer);
            serializationFieldOptions = this.detectSerializationFieldOptionsList(type);
            serializationFieldOptions.allFields().forEach(scanInformationBuilder::addSerializationField);
        } else {
            customPrimitiveSerializers = null;
            serializationFieldOptions = null;
        }
        if (capabilities.hasDeserialization()) {
            serializedObjectDeserializers = this.detectSerializedObjectDeserializers(type);
            serializedObjectDeserializers.forEach(scanInformationBuilder::addDeserializer);
            customPrimitiveDeserializers = this.detectCustomPrimitiveDeserializers(type);
            customPrimitiveDeserializers.forEach(scanInformationBuilder::addDeserializer);
        } else {
            serializedObjectDeserializers = null;
            customPrimitiveDeserializers = null;
        }
        Disambiguator disambiguator = disambiguators.disambiguatorFor(type);
        SerializedObjectOptions serializedObjectOptions = SerializedObjectOptions.serializedObjectOptions(serializationFieldOptions, serializedObjectDeserializers);
        SerializersAndDeserializers customPrimitiveOptions = SerializersAndDeserializers.serializersAndDeserializers(customPrimitiveSerializers, customPrimitiveDeserializers);
        return disambiguator.disambiguate(type, serializedObjectOptions, customPrimitiveOptions, scanInformationBuilder, injectedTypes);
    }

    private static Optional<DetectionResult<DisambiguationResult>> validateForSupportedFeatures(ResolvedType type) {
        if (!SimpleDetector.isSupported(type)) {
            return Optional.of(DetectionResult.failure(String.format("type '%s' is not supported because it contains wildcard generics (\"?\")", type.description())));
        }
        if (type.isAnnotation()) {
            return Optional.of(DetectionResult.failure(String.format("type '%s' cannot be detected because it is an annotation (you can still register it manually)", type.description())));
        }
        if (type.isAnonymousClass()) {
            return Optional.of(DetectionResult.failure(String.format("type '%s' cannot be detected because it is an anonymous class (you can still register it manually)", type.description())));
        }
        if (type.isLocalClass()) {
            return Optional.of(DetectionResult.failure(String.format("type '%s' cannot be detected because it is a local class (you can still register it manually)", type.description())));
        }
        if (type.isInnerClass() && !type.isStatic()) {
            return Optional.of(DetectionResult.failure(String.format("type '%s' cannot be detected because it is a non-static inner class (you can still register it manually)", type.description())));
        }
        if (!type.isPublic()) {
            return Optional.of(DetectionResult.failure(String.format("type '%s' cannot be detected because it is not public (you can still register it manually)", type.description())));
        }
        return Optional.empty();
    }

    private static boolean isSupported(ResolvedType resolvedType) {
        if (resolvedType.isWildcard()) {
            return false;
        }
        return resolvedType.typeParameters().stream().allMatch(SimpleDetector::isSupported);
    }

    private List<TypeSerializer> detectCustomPrimitiveSerializers(ResolvedType type) {
        return this.customPrimitiveSerializationDetectors.stream().map(detector -> detector.detect(type)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private SerializationFieldOptions detectSerializationFieldOptionsList(ResolvedType type) {
        SerializationFieldOptions serializationFieldOptions = SerializationFieldOptions.serializationFieldOptions();
        this.fieldDetectors.stream().map(fieldDetector -> fieldDetector.detect(type)).flatMap(Collection::stream).forEach(serializationFieldOptions::add);
        return serializationFieldOptions;
    }

    private List<TypeDeserializer> detectSerializedObjectDeserializers(ResolvedType type) {
        return this.serializedObjectDeserializationDetectors.stream().map(detector -> detector.detect(type)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<TypeDeserializer> detectCustomPrimitiveDeserializers(ResolvedType type) {
        return this.customPrimitiveDeserializationDetectors.stream().map(detector -> detector.detect(type)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Generated
    public String toString() {
        return "SimpleDetector(fieldDetectors=" + this.fieldDetectors + ", serializedObjectDeserializationDetectors=" + this.serializedObjectDeserializationDetectors + ", customPrimitiveSerializationDetectors=" + this.customPrimitiveSerializationDetectors + ", customPrimitiveDeserializationDetectors=" + this.customPrimitiveDeserializationDetectors + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleDetector)) {
            return false;
        }
        SimpleDetector other = (SimpleDetector)o;
        List<FieldDetector> this$fieldDetectors = this.fieldDetectors;
        List<FieldDetector> other$fieldDetectors = other.fieldDetectors;
        if (this$fieldDetectors == null ? other$fieldDetectors != null : !((Object)this$fieldDetectors).equals(other$fieldDetectors)) {
            return false;
        }
        List<SerializedObjectDeserializationDetector> this$serializedObjectDeserializationDetectors = this.serializedObjectDeserializationDetectors;
        List<SerializedObjectDeserializationDetector> other$serializedObjectDeserializationDetectors = other.serializedObjectDeserializationDetectors;
        if (this$serializedObjectDeserializationDetectors == null ? other$serializedObjectDeserializationDetectors != null : !((Object)this$serializedObjectDeserializationDetectors).equals(other$serializedObjectDeserializationDetectors)) {
            return false;
        }
        List<CustomPrimitiveSerializationDetector> this$customPrimitiveSerializationDetectors = this.customPrimitiveSerializationDetectors;
        List<CustomPrimitiveSerializationDetector> other$customPrimitiveSerializationDetectors = other.customPrimitiveSerializationDetectors;
        if (this$customPrimitiveSerializationDetectors == null ? other$customPrimitiveSerializationDetectors != null : !((Object)this$customPrimitiveSerializationDetectors).equals(other$customPrimitiveSerializationDetectors)) {
            return false;
        }
        List<CustomPrimitiveDeserializationDetector> this$customPrimitiveDeserializationDetectors = this.customPrimitiveDeserializationDetectors;
        List<CustomPrimitiveDeserializationDetector> other$customPrimitiveDeserializationDetectors = other.customPrimitiveDeserializationDetectors;
        return !(this$customPrimitiveDeserializationDetectors == null ? other$customPrimitiveDeserializationDetectors != null : !((Object)this$customPrimitiveDeserializationDetectors).equals(other$customPrimitiveDeserializationDetectors));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<FieldDetector> $fieldDetectors = this.fieldDetectors;
        result = result * 59 + ($fieldDetectors == null ? 43 : ((Object)$fieldDetectors).hashCode());
        List<SerializedObjectDeserializationDetector> $serializedObjectDeserializationDetectors = this.serializedObjectDeserializationDetectors;
        result = result * 59 + ($serializedObjectDeserializationDetectors == null ? 43 : ((Object)$serializedObjectDeserializationDetectors).hashCode());
        List<CustomPrimitiveSerializationDetector> $customPrimitiveSerializationDetectors = this.customPrimitiveSerializationDetectors;
        result = result * 59 + ($customPrimitiveSerializationDetectors == null ? 43 : ((Object)$customPrimitiveSerializationDetectors).hashCode());
        List<CustomPrimitiveDeserializationDetector> $customPrimitiveDeserializationDetectors = this.customPrimitiveDeserializationDetectors;
        result = result * 59 + ($customPrimitiveDeserializationDetectors == null ? 43 : ((Object)$customPrimitiveDeserializationDetectors).hashCode());
        return result;
    }

    @Generated
    private SimpleDetector(List<FieldDetector> fieldDetectors, List<SerializedObjectDeserializationDetector> serializedObjectDeserializationDetectors, List<CustomPrimitiveSerializationDetector> customPrimitiveSerializationDetectors, List<CustomPrimitiveDeserializationDetector> customPrimitiveDeserializationDetectors) {
        this.fieldDetectors = fieldDetectors;
        this.serializedObjectDeserializationDetectors = serializedObjectDeserializationDetectors;
        this.customPrimitiveSerializationDetectors = customPrimitiveSerializationDetectors;
        this.customPrimitiveDeserializationDetectors = customPrimitiveDeserializationDetectors;
    }
}

