/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.mapper.definitions;

import de.quantummaid.mapmaid.debug.DebugInformation;
import de.quantummaid.mapmaid.mapper.definitions.Definition;
import de.quantummaid.mapmaid.mapper.definitions.DefinitionNotFoundException;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

public final class Definitions {
    private final Map<TypeIdentifier, Definition> definitions;
    private final DebugInformation debugInformation;

    public static Definitions definitions(Map<TypeIdentifier, Definition> definitions, DebugInformation debugInformation) {
        return new Definitions(definitions, debugInformation);
    }

    public Definition getDefinitionForType(TypeIdentifier targetType) {
        return this.getOptionalDefinitionForType(targetType).orElseThrow(() -> DefinitionNotFoundException.definitionNotFound(targetType, this.debugInformation.dumpAll()));
    }

    public Optional<Definition> getOptionalDefinitionForType(TypeIdentifier targetType) {
        if (!this.definitions.containsKey(targetType)) {
            return Optional.empty();
        }
        return Optional.of(this.definitions.get(targetType));
    }

    @Generated
    public String toString() {
        return "Definitions(definitions=" + this.definitions + ", debugInformation=" + this.debugInformation + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Definitions)) {
            return false;
        }
        Definitions other = (Definitions)o;
        Map<TypeIdentifier, Definition> this$definitions = this.definitions;
        Map<TypeIdentifier, Definition> other$definitions = other.definitions;
        if (this$definitions == null ? other$definitions != null : !((Object)this$definitions).equals(other$definitions)) {
            return false;
        }
        DebugInformation this$debugInformation = this.debugInformation;
        DebugInformation other$debugInformation = other.debugInformation;
        return !(this$debugInformation == null ? other$debugInformation != null : !((Object)this$debugInformation).equals(other$debugInformation));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<TypeIdentifier, Definition> $definitions = this.definitions;
        result = result * 59 + ($definitions == null ? 43 : ((Object)$definitions).hashCode());
        DebugInformation $debugInformation = this.debugInformation;
        result = result * 59 + ($debugInformation == null ? 43 : ((Object)$debugInformation).hashCode());
        return result;
    }

    @Generated
    private Definitions(Map<TypeIdentifier, Definition> definitions, DebugInformation debugInformation) {
        this.definitions = definitions;
        this.debugInformation = debugInformation;
    }
}

