/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.mapper.deserialization.deserializers.collections;

import de.quantummaid.mapmaid.debug.DebugInformation;
import de.quantummaid.mapmaid.mapper.deserialization.DeserializerCallback;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.TypeDeserializer;
import de.quantummaid.mapmaid.mapper.deserialization.validation.ExceptionTracker;
import de.quantummaid.mapmaid.mapper.injector.Injector;
import de.quantummaid.mapmaid.mapper.universal.Universal;
import de.quantummaid.mapmaid.mapper.universal.UniversalCollection;
import de.quantummaid.mapmaid.mapper.universal.UniversalNull;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.mapmaid.shared.mapping.CustomPrimitiveMappings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public interface CollectionDeserializer
extends TypeDeserializer {
    public TypeIdentifier contentType();

    @Override
    default public List<TypeIdentifier> requiredTypes() {
        return Collections.singletonList(this.contentType());
    }

    public Object listToCollection(List<Object> var1);

    @Override
    default public <T> T deserialize(Universal input, ExceptionTracker exceptionTracker, Injector injector, DeserializerCallback callback, CustomPrimitiveMappings customPrimitiveMappings, TypeIdentifier typeIdentifier, DebugInformation debugInformation) {
        if (input instanceof UniversalNull) {
            return null;
        }
        UniversalCollection universalCollection = TypeDeserializer.castSafely(input, UniversalCollection.class, exceptionTracker, typeIdentifier, debugInformation);
        ArrayList<Object> deserializedList = new ArrayList<Object>(10);
        TypeIdentifier contentType = this.contentType();
        int index = 0;
        for (Universal element : universalCollection.content()) {
            Object deserialized = callback.deserializeRecursive(element, contentType, exceptionTracker.stepIntoArray(index), injector, debugInformation);
            deserializedList.add(deserialized);
            ++index;
        }
        return (T)this.listToCollection(deserializedList);
    }
}

