/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.shared.identifier;

import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import de.quantummaid.reflectmaid.ResolvedType;
import java.util.UUID;
import lombok.Generated;

public final class VirtualTypeIdentifier
implements TypeIdentifier {
    private final String id;

    public static TypeIdentifier virtualTypeIdentifier(String id) {
        NotNullValidator.validateNotNull(id, "id");
        return new VirtualTypeIdentifier(id);
    }

    public static TypeIdentifier uniqueVirtualTypeIdentifier() {
        String id = UUID.randomUUID().toString();
        return new VirtualTypeIdentifier(id);
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    @Override
    public ResolvedType getRealType() {
        throw new UnsupportedOperationException(String.format("Virtual type '%s' does not have a real type", this.description()));
    }

    @Override
    public String description() {
        return String.format("<virtual type '%s'>", this.id);
    }

    @Generated
    public String toString() {
        return "VirtualTypeIdentifier(id=" + this.id + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VirtualTypeIdentifier)) {
            return false;
        }
        VirtualTypeIdentifier other = (VirtualTypeIdentifier)o;
        String this$id = this.id;
        String other$id = other.id;
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.id;
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    private VirtualTypeIdentifier(String id) {
        this.id = id;
    }
}

