/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.treetable.j;

import de.sciss.treetable.j.TreeColumnModel;
import de.sciss.treetable.j.event.TreeColumnModelEvent;
import de.sciss.treetable.j.event.TreeColumnModelListener;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.swing.event.EventListenerList;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class AbstractTreeColumnModel
implements TreeColumnModel {
    protected EventListenerList listenerList = new EventListenerList();

    @Override
    public String getColumnName(int column) {
        String str = Character.toString((char)(65 + column % 26));
        while (column > 25) {
            column = column / 26 - 1;
            str = str + (char)(65 + column % 26);
        }
        return str;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return Object.class;
    }

    @Override
    public void setValueAt(Object value, Object node, int column) {
    }

    protected Object convertValue(Object value, Object node, int column) {
        try {
            return AbstractTreeColumnModel.convertValue(value, this.getColumnClass(column));
        }
        catch (NumberFormatException e) {
            return this.convertValue(value, node, column, e);
        }
    }

    protected Object convertValue(Object value, Object node, int column, NumberFormatException e) {
        return value;
    }

    @Override
    public boolean isCellEditable(Object node, int column) {
        return false;
    }

    @Override
    public int getHierarchicalColumn() {
        return 0;
    }

    @Override
    public void addTreeColumnModelListener(TreeColumnModelListener l) {
        this.listenerList.add(TreeColumnModelListener.class, l);
    }

    @Override
    public void removeTreeColumnModelListener(TreeColumnModelListener l) {
        this.listenerList.remove(TreeColumnModelListener.class, l);
    }

    protected void fireTreeColumnChanged(TreePath path, int column) {
        AbstractTreeColumnModel.fireTreeColumnChanged(this.listenerList, this, path, column);
    }

    public static void fireTreeColumnChanged(EventListenerList listenerList, TreeColumnModel source, TreePath path, int column) {
        Object[] listeners = listenerList.getListenerList();
        TreeColumnModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeColumnModelListener.class) continue;
            if (e == null) {
                e = new TreeColumnModelEvent(source, path, column);
            }
            ((TreeColumnModelListener)listeners[i + 1]).treeColumnChanged(e);
        }
    }

    public static TreePath pathToRoot(Object root, TreeNode node) {
        if (node == root || node.getParent() == null) {
            return new TreePath(node);
        }
        return AbstractTreeColumnModel.pathToRoot(root, node.getParent()).pathByAddingChild(node);
    }

    public static Object convertValue(Object value, Class<?> cls) throws NumberFormatException {
        if (cls == Object.class || cls == String.class) {
            return value;
        }
        if (cls == Boolean.class) {
            if (value instanceof Boolean) {
                return value;
            }
            return value == null ? Boolean.FALSE : Boolean.valueOf(value.toString());
        }
        if (Number.class.isAssignableFrom(cls) && value instanceof String) {
            if (cls == Integer.class) {
                value = Integer.valueOf((String)value);
            } else if (cls == Long.class) {
                value = Long.valueOf((String)value);
            } else if (cls == Float.class) {
                value = Float.valueOf((String)value);
            } else if (cls == Double.class) {
                value = Double.valueOf((String)value);
            } else {
                if (cls == BigInteger.class) {
                    return new BigInteger((String)value);
                }
                if (cls == BigDecimal.class) {
                    return new BigDecimal((String)value);
                }
                if (cls == Short.class) {
                    value = Short.valueOf((String)value);
                } else if (cls == Byte.class) {
                    value = Byte.valueOf((String)value);
                }
            }
        }
        return value;
    }
}

