/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.treetable.j;

import de.sciss.treetable.j.DefaultTreeTableSorter;
import de.sciss.treetable.j.TreeColumnModel;
import de.sciss.treetable.j.TreeTableSorter;
import de.sciss.treetable.j.event.TreeTableSorterEvent;
import de.sciss.treetable.j.event.TreeTableSorterListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultRowSorter;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.EventListenerList;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class DefaultTreeTableSorter<T extends TreeModel, C extends TreeColumnModel, I>
implements TreeTableSorter<T, C>,
TreeTableSorter.SortCycle {
    public static final List<SortOrder> ASCENDING_DESCENDING = Collections.unmodifiableList(Arrays.asList(SortOrder.ASCENDING, SortOrder.DESCENDING));
    public static final List<SortOrder> ASCENDING_DESCENDING_UNSORTED = Collections.unmodifiableList(Arrays.asList(SortOrder.ASCENDING, SortOrder.DESCENDING, SortOrder.UNSORTED));
    public static final Comparator<Object> COMPARABLE_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object a, Object b) {
            return ((Comparable)a).compareTo((Comparable)b);
        }
    };
    protected EventListenerList listenerList = new EventListenerList();
    private T treeModel;
    private C columnModel;
    private IdentityHashMap<Object, NodeSorter> sorters;
    private List<? extends RowSorter.SortKey> sortKeys = Collections.emptyList();
    private boolean[] isSortable;
    private Comparator[] comparators;
    private RowFilter<? super T, ? super I> rowFilter;
    private List<SortOrder> sortCycle = ASCENDING_DESCENDING;
    private int maxSortKeys = 3;
    private boolean sortsOnUpdates;

    public DefaultTreeTableSorter(T tm, C cm) {
        this.treeModel = tm;
        this.columnModel = cm;
        this.sorters = new IdentityHashMap();
        this.sorters.put(tm.getRoot(), new NodeSorter(tm.getRoot()));
    }

    public NodeSorter getRowSorter(Object node) {
        return this.sorters.get(node);
    }

    public NodeSorter getRowSorter(TreePath path) {
        IdentityHashMap<Object, NodeSorter> sorterMap = this.sorters;
        NodeSorter sorter = (NodeSorter)sorterMap.get(path.getPathComponent(0));
        int count = path.getPathCount();
        for (int idx = 1; idx < count; ++idx) {
            Object node = path.getPathComponent(idx);
            sorter = sorter.getChildSorter(node, sorterMap);
        }
        return sorter;
    }

    public T getTreeModel() {
        return this.treeModel;
    }

    public C getTreeColumnModel() {
        return this.columnModel;
    }

    public boolean getSortsOnUpdates() {
        return this.sortsOnUpdates;
    }

    public void setSortsOnUpdates(boolean sorts) {
        this.sortsOnUpdates = sorts;
    }

    public int getMaxSortKeys() {
        return this.maxSortKeys;
    }

    public void setMaxSortKeys(int max) {
        if (max < 1) {
            throw new IllegalArgumentException("Invalid max");
        }
        this.maxSortKeys = max;
    }

    public void setSortable(int column, boolean sortable) {
        this.checkColumn(column);
        if (this.isSortable == null) {
            if (sortable) {
                return;
            }
            this.isSortable = new boolean[this.columnModel.getColumnCount()];
            Arrays.fill(this.isSortable, true);
        }
        this.isSortable[column] = sortable;
    }

    public boolean isSortable(int column) {
        return this.isSortable == null || this.isSortable[column];
    }

    public void setComparator(int column, Comparator<?> comparator) {
        this.checkColumn(column);
        if (this.comparators == null) {
            if (comparator == null) {
                return;
            }
            this.comparators = new Comparator[this.columnModel.getColumnCount()];
        }
        this.comparators[column] = comparator;
    }

    boolean isComparatorSet(int column) {
        return this.comparators != null && this.comparators[column] != null;
    }

    public Comparator<?> getComparator(int column) {
        if (this.isComparatorSet(column)) {
            return this.comparators[column];
        }
        Class<?> cls = this.columnModel.getColumnClass(column);
        if (cls == String.class) {
            return Collator.getInstance();
        }
        if (Comparable.class.isAssignableFrom(cls)) {
            return COMPARABLE_COMPARATOR;
        }
        return Collator.getInstance();
    }

    public void setRowFilter(RowFilter<? super T, ? super I> filter) {
        if (filter == null && this.rowFilter == null) {
            return;
        }
        this.rowFilter = filter;
        this.sort();
    }

    public RowFilter<? super T, ? super I> getRowFilter() {
        return this.rowFilter;
    }

    @Override
    public List<? extends RowSorter.SortKey> getSortKeys() {
        return this.sortKeys;
    }

    @Override
    public void setSortKeys(List<? extends RowSorter.SortKey> keys) {
        List<? extends RowSorter.SortKey> old = this.sortKeys;
        this.sortKeys = keys != null && !keys.isEmpty() ? Collections.unmodifiableList(new ArrayList<RowSorter.SortKey>(keys)) : Collections.emptyList();
        if (!((Object)this.sortKeys).equals(old)) {
            this.fireSortOrderChanged();
            this.sort();
        }
    }

    @Override
    public void toggleSortOrder(int column) {
        this.checkColumn(column);
        if (this.isSortable(column)) {
            List<RowSorter.SortKey> keys = DefaultTreeTableSorter.toggleSortOrder(this.getSortKeys(), this.getSortCycle(), column, this.getMaxSortKeys());
            this.setSortKeys(keys);
        }
    }

    static List<RowSorter.SortKey> toggleSortOrder(List<? extends RowSorter.SortKey> sortKeys, List<SortOrder> sortCycle, int column, int maxSortKeys) {
        int sortIndex;
        List<RowSorter.SortKey> keys = new ArrayList<RowSorter.SortKey>(sortKeys);
        for (sortIndex = keys.size() - 1; sortIndex >= 0 && ((RowSorter.SortKey)keys.get(sortIndex)).getColumn() != column; --sortIndex) {
        }
        if (sortIndex == -1) {
            RowSorter.SortKey sortKey = new RowSorter.SortKey(column, sortCycle.get(0));
            keys.add(0, sortKey);
        } else if (sortIndex == 0) {
            RowSorter.SortKey key = (RowSorter.SortKey)keys.get(0);
            int idx = sortCycle.indexOf((Object)key.getSortOrder());
            if (idx < 0 || ++idx >= sortCycle.size()) {
                idx = 0;
            }
            keys.set(0, new RowSorter.SortKey(key.getColumn(), sortCycle.get(idx)));
        } else {
            keys.remove(sortIndex);
            keys.add(0, new RowSorter.SortKey(column, sortCycle.get(0)));
        }
        if (keys.size() > maxSortKeys) {
            keys = keys.subList(0, maxSortKeys);
        }
        return keys;
    }

    @Override
    public List<SortOrder> getSortCycle() {
        return this.sortCycle;
    }

    @Override
    public void setSortCycle(List<SortOrder> sortCycle) {
        if (sortCycle.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.sortCycle = sortCycle;
    }

    private void checkColumn(int column) {
        if (column < 0 || column >= this.columnModel.getColumnCount()) {
            throw new IndexOutOfBoundsException();
        }
    }

    public void sort() {
        this.getRowSorter(this.treeModel.getRoot()).sort(true);
        this.fireSorterChanged();
    }

    @Override
    public void addTreeTableSorterListener(TreeTableSorterListener l) {
        this.listenerList.add(TreeTableSorterListener.class, l);
    }

    @Override
    public void removeTreeTableSorterListener(TreeTableSorterListener l) {
        this.listenerList.remove(TreeTableSorterListener.class, l);
    }

    protected void fireSortOrderChanged() {
        this.fire(new TreeTableSorterEvent(this));
    }

    protected void fireSorterChanged() {
        this.fire(new TreeTableSorterEvent(this, null));
    }

    protected void fireRowSorterChanged(TreePath path) {
        this.fire(new TreeTableSorterEvent(this, path));
    }

    private void fire(TreeTableSorterEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeTableSorterListener.class) continue;
            ((TreeTableSorterListener)listeners[i + 1]).sorterChanged(e);
        }
    }

    @Override
    public void structureChanged(TreePath path, boolean newRoot) {
        if (newRoot) {
            this.sorters.clear();
            this.sorters.put(this.treeModel.getRoot(), new NodeSorter(this.treeModel.getRoot()));
        } else {
            NodeSorter s = this.getRowSorter(path.getLastPathComponent());
            s.removeAllChildren(this.sorters);
        }
    }

    @Override
    public void nodesRemoved(TreePath path, Object[] childNodes) {
        NodeSorter sorter = this.getRowSorter(path.getLastPathComponent());
        if (sorter != null) {
            sorter.remove(childNodes, this.sorters);
        }
    }

    @Override
    public void setVisible(TreePath path, List<TreePath> subPaths, boolean visible) {
        NodeSorter sorter = this.getRowSorter(path);
        sorter.setVisible(visible);
        if (visible) {
            for (TreePath p : subPaths) {
                NodeSorter s = sorter;
                int count = p.getPathCount();
                for (int idx = path.getPathCount(); idx < count; ++idx) {
                    Object node = p.getPathComponent(idx);
                    s = s.getChildSorter(node, this.sorters);
                    s.setVisible(true);
                }
            }
            sorter.sort(true);
        }
    }

    public class NodeSorter
    extends DefaultRowSorter<T, I>
    implements TreeTableSorter.SortCycle {
        private NodeSorter parent;
        private Map<Object, NodeSorter> children;
        private List<SortOrder> sortCycle = ASCENDING_DESCENDING_UNSORTED;
        private boolean visible;
        private boolean firePathEvent = true;

        public NodeSorter(Object root) {
            this(null, root);
            this.setVisible(true);
        }

        public NodeSorter(NodeSorter par, Object node) {
            this.parent = par;
            this.setModelWrapper(new TreeTableWrapper(node));
            this.children = this.createChildren();
            if (this.parent != null) {
                this.setMaxSortKeys(Integer.MAX_VALUE);
            }
        }

        protected Map<Object, NodeSorter> createChildren() {
            return new IdentityHashMap<Object, NodeSorter>(((TreeModel)this.getModel()).getChildCount(this.getNode()));
        }

        public NodeSorter getParent() {
            return this.parent;
        }

        DefaultTreeTableSorter<T, C, I> getMaster() {
            return DefaultTreeTableSorter.this;
        }

        NodeSorter getChildSorter(Object node, Map<Object, NodeSorter> map) {
            NodeSorter s = this.children.get(node);
            if (s == null && map != null) {
                s = new NodeSorter(this, node);
                this.children.put(node, s);
                map.put(node, s);
            }
            return s;
        }

        protected de.sciss.treetable.j.DefaultTreeTableSorter$NodeSorter.TreeTableWrapper getTreeTableModelWrapper() {
            return (TreeTableWrapper)this.getModelWrapper();
        }

        public Object getNode() {
            return this.getTreeTableModelWrapper().getNode();
        }

        public C getColumnModel() {
            return this.getTreeTableModelWrapper().getColumnModel();
        }

        @Override
        public Comparator<?> getComparator(int column) {
            Comparator<?> c = super.getComparator(column);
            return c != null ? c : this.getMaster().getComparator(column);
        }

        @Override
        protected boolean useToString(int column) {
            if (super.getComparator(column) != null || this.getMaster().isComparatorSet(column)) {
                return false;
            }
            Class<?> columnClass = this.getColumnModel().getColumnClass(column);
            if (columnClass == String.class) {
                return false;
            }
            return !Comparable.class.isAssignableFrom(columnClass);
        }

        @Override
        public List<? extends RowSorter.SortKey> getSortKeys() {
            List<RowSorter.SortKey> k = super.getSortKeys();
            return !k.isEmpty() ? k : this.getMaster().getSortKeys();
        }

        @Override
        public int getMaxSortKeys() {
            int m = super.getMaxSortKeys();
            return m < Integer.MAX_VALUE ? m : this.getMaster().getMaxSortKeys();
        }

        @Override
        public RowFilter<? super T, ? super I> getRowFilter() {
            RowFilter f = super.getRowFilter();
            if (f != null) {
                return f;
            }
            return this.getMaster().getRowFilter();
        }

        @Override
        public boolean getSortsOnUpdates() {
            return this.getMaster().getSortsOnUpdates();
        }

        @Override
        public boolean isSortable(int column) {
            return this.getMaster().isSortable(column);
        }

        @Override
        public void setSortCycle(List<SortOrder> sortCycle) {
            if (sortCycle.isEmpty()) {
                throw new IllegalArgumentException();
            }
            this.sortCycle = sortCycle;
        }

        @Override
        public List<SortOrder> getSortCycle() {
            return this.sortCycle;
        }

        @Override
        public void toggleSortOrder(int column) {
            DefaultTreeTableSorter.this.checkColumn(column);
            if (this.isSortable(column)) {
                List<RowSorter.SortKey> keys = DefaultTreeTableSorter.toggleSortOrder(super.getSortKeys(), this.getSortCycle(), column, this.getMaxSortKeys());
                this.setSortKeys(keys);
            }
        }

        @Override
        public void setSortsOnUpdates(boolean sortsOnUpdates) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setSortable(int column, boolean sortable) {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sort(boolean sortChildren) {
            if (!this.isVisible()) {
                return;
            }
            this.firePathEvent = false;
            try {
                super.sort();
            }
            finally {
                this.firePathEvent = true;
            }
            if (!sortChildren) {
                return;
            }
            for (NodeSorter sorter : this.children.values()) {
                sorter.sort(sortChildren);
            }
        }

        @Override
        protected void fireRowSorterChanged(int[] lastRowIndexToModel) {
            super.fireRowSorterChanged(lastRowIndexToModel);
            if (this.firePathEvent) {
                this.getMaster().fireRowSorterChanged(this.getPathToRoot());
            }
        }

        private TreePath getPathToRoot() {
            if (this.parent == null) {
                return new TreePath(this.getNode());
            }
            return this.parent.getPathToRoot().pathByAddingChild(this.getNode());
        }

        @Override
        public void allRowsChanged() {
            this.getTreeTableModelWrapper().updateRowCount();
            super.allRowsChanged();
        }

        @Override
        public void rowsDeleted(int firstRow, int endRow) {
            this.getTreeTableModelWrapper().updateRowCount();
            super.rowsDeleted(firstRow, endRow);
        }

        @Override
        public void rowsInserted(int firstRow, int endRow) {
            this.getTreeTableModelWrapper().updateRowCount();
            super.rowsInserted(firstRow, endRow);
        }

        public void setVisible(boolean vis) {
            if (this.visible != vis) {
                this.visible = vis;
                if (vis) {
                    this.sort(true);
                }
            }
        }

        public boolean isVisible() {
            return this.visible;
        }

        void removeAllChildren(Map<Object, NodeSorter> map) {
            for (Map.Entry<Object, NodeSorter> entry : this.children.entrySet()) {
                map.remove(entry.getKey());
                entry.getValue().removeAllChildren(map);
            }
            this.children.clear();
        }

        void remove(Object[] childNodes, Map<Object, NodeSorter> map) {
            for (Object node : childNodes) {
                NodeSorter s = this.children.remove(node);
                if (s == null) continue;
                s.removeAllChildren(map);
            }
        }

        protected class TreeTableWrapper
        extends DefaultRowSorter.ModelWrapper<T, I> {
            private Object node;
            private int rowCount;

            public TreeTableWrapper(Object n) {
                this.node = n;
                this.updateRowCount();
            }

            public Object getNode() {
                return this.node;
            }

            public C getColumnModel() {
                return DefaultTreeTableSorter.this.columnModel;
            }

            @Override
            public int getColumnCount() {
                return DefaultTreeTableSorter.this.columnModel.getColumnCount();
            }

            @Override
            public I getIdentifier(int row) {
                return DefaultTreeTableSorter.this.treeModel.getChild(this.node, row);
            }

            @Override
            public T getModel() {
                return DefaultTreeTableSorter.this.treeModel;
            }

            @Override
            public int getRowCount() {
                return this.rowCount;
            }

            public void updateRowCount() {
                this.rowCount = DefaultTreeTableSorter.this.treeModel.getChildCount(this.node);
            }

            @Override
            public Object getValueAt(int row, int column) {
                return DefaultTreeTableSorter.this.columnModel.getValueAt(DefaultTreeTableSorter.this.treeModel.getChild(this.node, row), column);
            }
        }
    }
}

