/*
 * Decompiled with CFR 0.152.
 */
package dev.alexengrig.util.lambda;

import dev.alexengrig.util.lambda.TerConsumer;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public final class ConsumerCurrying {
    private ConsumerCurrying() {
    }

    public static <F> Runnable all(Consumer<F> consumer, F first) {
        Objects.requireNonNull(consumer, "The consumer must not be null");
        return () -> consumer.accept(first);
    }

    public static <F, S> Function<F, Consumer<S>> left2(BiConsumer<F, S> biConsumer) {
        Objects.requireNonNull(biConsumer, "The bi-consumer must not be null");
        return first -> second -> biConsumer.accept(first, second);
    }

    public static <F, S> Consumer<S> left2(BiConsumer<F, S> biConsumer, F first) {
        Objects.requireNonNull(biConsumer, "The bi-consumer must not be null");
        return second -> biConsumer.accept(first, second);
    }

    public static <F, S> Runnable all2(BiConsumer<F, S> biConsumer, F first, S second) {
        Objects.requireNonNull(biConsumer, "The bi-consumer must not be null");
        return () -> biConsumer.accept(first, second);
    }

    public static <F, S, T> Function<F, Function<S, Consumer<T>>> left3(TerConsumer<F, S, T> terConsumer) {
        Objects.requireNonNull(terConsumer, "The ter-consumer must not be null");
        return first -> second -> third -> terConsumer.accept(first, second, third);
    }

    public static <F, S, T> Function<S, Consumer<T>> left3(TerConsumer<F, S, T> terConsumer, F first) {
        Objects.requireNonNull(terConsumer, "The ter-consumer must not be null");
        return second -> third -> terConsumer.accept(first, second, third);
    }

    public static <F, S, T> Consumer<T> left3(TerConsumer<F, S, T> terConsumer, F first, S second) {
        Objects.requireNonNull(terConsumer, "The ter-consumer must not be null");
        return third -> terConsumer.accept(first, second, third);
    }

    public static <F, S, T> Runnable all3(TerConsumer<F, S, T> terConsumer, F first, S second, T third) {
        Objects.requireNonNull(terConsumer, "The ter-consumer must not be null");
        return () -> terConsumer.accept(first, second, third);
    }

    public static <F, S, T> Function<F, Consumer<T>> leftMiddle3(TerConsumer<F, S, T> terConsumer, S second) {
        Objects.requireNonNull(terConsumer, "The ter-consumer must not be null");
        return first -> third -> terConsumer.accept(first, second, third);
    }

    public static <F, S, T> Consumer<S> middle3(TerConsumer<F, S, T> terConsumer, F first, T third) {
        Objects.requireNonNull(terConsumer, "The ter-consumer must not be null");
        return second -> terConsumer.accept(first, second, third);
    }

    public static <F, S, T> Function<T, Consumer<F>> rightMiddle3(TerConsumer<F, S, T> terConsumer, S second) {
        Objects.requireNonNull(terConsumer, "The ter-consumer must not be null");
        return third -> first -> terConsumer.accept(first, second, third);
    }

    public static <F, S> Function<S, Consumer<F>> right2(BiConsumer<F, S> biConsumer) {
        Objects.requireNonNull(biConsumer, "The bi-consumer must not be null");
        return second -> first -> biConsumer.accept(first, second);
    }

    public static <F, S> Consumer<F> right2(BiConsumer<F, S> biConsumer, S second) {
        Objects.requireNonNull(biConsumer, "The bi-consumer must not be null");
        return first -> biConsumer.accept(first, second);
    }

    public static <F, S, T> Function<T, Function<S, Consumer<F>>> right3(TerConsumer<F, S, T> terConsumer) {
        Objects.requireNonNull(terConsumer, "The ter-consumer must not be null");
        return third -> second -> first -> terConsumer.accept(first, second, third);
    }

    public static <F, S, T> Function<S, Consumer<F>> right3(TerConsumer<F, S, T> terConsumer, T third) {
        Objects.requireNonNull(terConsumer, "The ter-consumer must not be null");
        return second -> first -> terConsumer.accept(first, second, third);
    }

    public static <F, S, T> Consumer<F> right3(TerConsumer<F, S, T> terConsumer, S second, T third) {
        Objects.requireNonNull(terConsumer, "The ter-consumer must not be null");
        return first -> terConsumer.accept(first, second, third);
    }

    public static <F, S, T> BiConsumer<S, T> biLeft3(TerConsumer<F, S, T> terConsumer, F first) {
        Objects.requireNonNull(terConsumer, "The ter-consumer must not be null");
        return (second, third) -> terConsumer.accept(first, second, third);
    }

    public static <F, S, T> BiConsumer<F, T> biMiddle3(TerConsumer<F, S, T> terConsumer, S second) {
        Objects.requireNonNull(terConsumer, "The ter-consumer must not be null");
        return (first, third) -> terConsumer.accept(first, second, third);
    }

    public static <F, S, T> BiConsumer<F, S> biRight3(TerConsumer<F, S, T> terConsumer, T third) {
        Objects.requireNonNull(terConsumer, "The ter-consumer must not be null");
        return (first, second) -> terConsumer.accept(first, second, third);
    }
}

