/*
 * Decompiled with CFR 0.152.
 */
package dev.alexengrig.util.lambda;

import dev.alexengrig.util.lambda.TerFunction;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public final class FunctionCurrying {
    private FunctionCurrying() {
    }

    public static <F, R> Supplier<R> all(Function<F, R> function, F first) {
        Objects.requireNonNull(function, "The function must not be null");
        return () -> function.apply(first);
    }

    public static <F, S, R> Function<F, Function<S, R>> left2(BiFunction<F, S, R> biFunction) {
        Objects.requireNonNull(biFunction, "The bi-function must not be null");
        return first -> second -> biFunction.apply(first, second);
    }

    public static <F, S, R> Function<S, R> left2(BiFunction<F, S, R> biFunction, F first) {
        Objects.requireNonNull(biFunction, "The bi-function must not be null");
        return second -> biFunction.apply(first, second);
    }

    public static <F, S, R> Supplier<R> all2(BiFunction<F, S, R> biFunction, F first, S second) {
        Objects.requireNonNull(biFunction, "The bi-function must not be null");
        return () -> biFunction.apply(first, second);
    }

    public static <F, S, T, R> Function<F, Function<S, Function<T, R>>> left3(TerFunction<F, S, T, R> terFunction) {
        Objects.requireNonNull(terFunction, "The ter-function must not be null");
        return first -> second -> third -> terFunction.apply(first, second, third);
    }

    public static <F, S, T, R> Function<S, Function<T, R>> left3(TerFunction<F, S, T, R> terFunction, F first) {
        Objects.requireNonNull(terFunction, "The ter-function must not be null");
        return second -> third -> terFunction.apply(first, second, third);
    }

    public static <F, S, T, R> Function<T, R> left3(TerFunction<F, S, T, R> terFunction, F first, S second) {
        Objects.requireNonNull(terFunction, "The ter-function must not be null");
        return third -> terFunction.apply(first, second, third);
    }

    public static <F, S, T, R> Supplier<R> all3(TerFunction<F, S, T, R> terFunction, F first, S second, T third) {
        Objects.requireNonNull(terFunction, "The ter-function must not be null");
        return () -> terFunction.apply(first, second, third);
    }

    public static <F, S, T, R> Function<F, Function<T, R>> leftMiddle3(TerFunction<F, S, T, R> terFunction, S second) {
        Objects.requireNonNull(terFunction, "The ter-function must not be null");
        return first -> third -> terFunction.apply(first, second, third);
    }

    public static <F, S, T, R> Function<S, R> middle3(TerFunction<F, S, T, R> terFunction, F first, T third) {
        Objects.requireNonNull(terFunction, "The ter-function must not be null");
        return second -> terFunction.apply(first, second, third);
    }

    public static <F, S, T, R> Function<T, Function<F, R>> rightMiddle3(TerFunction<F, S, T, R> terFunction, S second) {
        Objects.requireNonNull(terFunction, "The ter-function must not be null");
        return third -> first -> terFunction.apply(first, second, third);
    }

    public static <F, S, R> Function<S, Function<F, R>> right2(BiFunction<F, S, R> biFunction) {
        Objects.requireNonNull(biFunction, "The bi-function must not be null");
        return second -> first -> biFunction.apply(first, second);
    }

    public static <F, S, R> Function<F, R> right2(BiFunction<F, S, R> biFunction, S second) {
        Objects.requireNonNull(biFunction, "The bi-function must not be null");
        return first -> biFunction.apply(first, second);
    }

    public static <F, S, T, R> Function<T, Function<S, Function<F, R>>> right3(TerFunction<F, S, T, R> terFunction) {
        Objects.requireNonNull(terFunction, "The ter-function must not be null");
        return third -> second -> first -> terFunction.apply(first, second, third);
    }

    public static <F, S, T, R> Function<S, Function<F, R>> right3(TerFunction<F, S, T, R> terFunction, T third) {
        Objects.requireNonNull(terFunction, "The ter-function must not be null");
        return second -> first -> terFunction.apply(first, second, third);
    }

    public static <F, S, T, R> Function<F, R> right3(TerFunction<F, S, T, R> terFunction, S second, T third) {
        Objects.requireNonNull(terFunction, "The ter-function must not be null");
        return first -> terFunction.apply(first, second, third);
    }

    public static <F, S, T, R> BiFunction<S, T, R> biLeft3(TerFunction<F, S, T, R> terFunction, F first) {
        Objects.requireNonNull(terFunction, "The ter-function must not be null");
        return (second, third) -> terFunction.apply(first, second, third);
    }

    public static <F, S, T, R> BiFunction<F, T, R> biMiddle3(TerFunction<F, S, T, R> terFunction, S second) {
        Objects.requireNonNull(terFunction, "The ter-function must not be null");
        return (first, third) -> terFunction.apply(first, second, third);
    }

    public static <F, S, T, R> BiFunction<F, S, R> biRight3(TerFunction<F, S, T, R> terFunction, T third) {
        Objects.requireNonNull(terFunction, "The ter-function must not be null");
        return (first, second) -> terFunction.apply(first, second, third);
    }
}

