/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator;

import java.util.HashMap;
import javax.annotation.Nonnull;
import org.xml.sax.Attributes;

public class ParsedHtmlTag {
    @Nonnull
    private String tagName;
    @Nonnull
    private final Attributes attrs;
    private HashMap<String, String> attrsByKey;

    public ParsedHtmlTag(@Nonnull String tagName, @Nonnull Attributes attributes) {
        this.tagName = tagName.toUpperCase();
        this.attrs = attributes;
        this.attrsByKey = null;
    }

    public String lowerName() {
        return this.tagName.toLowerCase();
    }

    public Attributes attrs() {
        return this.attrs;
    }

    public HashMap<String, String> attrsByKey() {
        if (this.attrsByKey == null) {
            this.attrsByKey = new HashMap();
            for (int i = 0; i < this.attrs.getLength(); ++i) {
                this.attrsByKey.put(this.attrs.getLocalName(i), this.attrs.getValue(i));
            }
        }
        return this.attrsByKey;
    }

    public String hasDuplicateAttrs() {
        String lastAttrName = "";
        String lastAttrValue = "";
        for (int i = 0; i < this.attrs.getLength(); ++i) {
            if (lastAttrName.equals(this.attrs.getLocalName(i)) && !lastAttrValue.equals(this.attrs.getValue(i))) {
                return this.attrs.getLocalName(i);
            }
            lastAttrName = this.attrs.getLocalName(i);
            lastAttrValue = this.attrs.getValue(i);
        }
        return null;
    }

    public String getValue(@Nonnull String attrName, int index) {
        String val = this.attrs.getValue(index);
        if (val != null && val.equals(attrName.toLowerCase())) {
            return "";
        }
        return val;
    }

    public void cleanup() {
        this.tagName = null;
        this.attrsByKey = null;
    }

    public String upperName() {
        return this.tagName.toUpperCase();
    }

    public boolean isEmpty() {
        return this.tagName.length() == 0;
    }
}

