/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator;

import dev.amp.validator.Context;
import dev.amp.validator.ParsedHtmlTag;
import dev.amp.validator.ParsedReferencePoints;
import dev.amp.validator.ParsedTagSpec;
import dev.amp.validator.ParsedValidatorRules;
import dev.amp.validator.ValidateTagResult;
import dev.amp.validator.ValidatorProtos;
import dev.amp.validator.css.CssValidationException;
import dev.amp.validator.exception.TagValidationException;
import dev.amp.validator.exception.ValidatorException;
import dev.amp.validator.utils.TagSpecUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.xml.sax.Locator;

public class ReferencePointMatcher {
    private ParsedValidatorRules parsedValidatorRules;
    private ParsedReferencePoints parsedReferencePoints;
    private Locator lineCol;
    private List<Integer> referencePointsMatched;

    public ReferencePointMatcher(@Nonnull ParsedValidatorRules parsedValidatorRules, @Nonnull ParsedReferencePoints parsedReferencePoints, @Nonnull Locator lineCol) throws TagValidationException {
        this.parsedValidatorRules = parsedValidatorRules;
        this.parsedReferencePoints = parsedReferencePoints;
        if (parsedReferencePoints.empty()) {
            throw new TagValidationException("Reference point matcher should not be empty");
        }
        this.lineCol = lineCol;
        this.referencePointsMatched = new ArrayList<Integer>();
    }

    public ValidateTagResult validateTag(@Nonnull ParsedHtmlTag tag, @Nonnull Context context) throws TagValidationException, ValidatorException, IOException, CssValidationException {
        ValidatorProtos.ValidationResult.Builder resultForBestAttempt = ValidatorProtos.ValidationResult.newBuilder();
        resultForBestAttempt.setStatus(ValidatorProtos.ValidationResult.Status.UNKNOWN);
        for (ValidatorProtos.ReferencePoint p : this.parsedReferencePoints.iterate()) {
            ParsedTagSpec parsedTagSpec = context.getRules().getByTagSpecId(p.getTagSpecName());
            if (!parsedTagSpec.isUsedForTypeIdentifiers(context.getTypeIdentifiers())) continue;
            ValidateTagResult resultForAttemptWrapper = TagSpecUtils.validateTagAgainstSpec(parsedTagSpec, null, context, tag);
            ValidatorProtos.ValidationResult.Builder resultForAttempt = resultForAttemptWrapper.getValidationResult();
            if (context.getRules().betterValidationResultThan(resultForAttempt, resultForBestAttempt)) {
                resultForBestAttempt = resultForAttempt;
            }
            if (resultForBestAttempt.getStatus() != ValidatorProtos.ValidationResult.Status.PASS) continue;
            ValidateTagResult validateTagResult = new ValidateTagResult(resultForBestAttempt, parsedTagSpec);
            return validateTagResult;
        }
        if (resultForBestAttempt.getStatus() != ValidatorProtos.ValidationResult.Status.FAIL) {
            throw new ValidatorException("Successful validation should have exited earlier");
        }
        if (this.parsedReferencePoints.size() == 1) {
            ArrayList<String> params = new ArrayList<String>();
            params.add(tag.lowerName());
            params.add(this.parsedReferencePoints.parentTagSpecName());
            params.add(this.parsedValidatorRules.getReferencePointName(this.parsedReferencePoints.iterate().get(0)));
            context.addError(ValidatorProtos.ValidationError.Code.CHILD_TAG_DOES_NOT_SATISFY_REFERENCE_POINT_SINGULAR, context.getLineCol(), params, this.parsedReferencePoints.parentSpecUrl(), resultForBestAttempt);
            ValidateTagResult validateTagResult = new ValidateTagResult(resultForBestAttempt, null);
            return validateTagResult;
        }
        ArrayList<String> acceptable = new ArrayList<String>();
        for (ValidatorProtos.ReferencePoint p : this.parsedReferencePoints.iterate()) {
            acceptable.add(this.parsedValidatorRules.getReferencePointName(p));
        }
        ValidatorProtos.ValidationResult.Builder resultForMultipleAttempts = ValidatorProtos.ValidationResult.newBuilder();
        ArrayList<String> params = new ArrayList<String>();
        params.add(tag.lowerName());
        params.add(this.parsedReferencePoints.parentTagSpecName());
        params.add(String.join((CharSequence)", ", acceptable));
        context.addError(ValidatorProtos.ValidationError.Code.CHILD_TAG_DOES_NOT_SATISFY_REFERENCE_POINT, context.getLineCol(), params, this.parsedReferencePoints.parentSpecUrl(), resultForMultipleAttempts);
        ValidateTagResult validateTagResult = new ValidateTagResult(resultForMultipleAttempts, null);
        return validateTagResult;
    }

    public void exitParentTag(@Nonnull Context context, @Nonnull ValidatorProtos.ValidationResult.Builder result) throws TagValidationException {
        HashMap<Integer, Integer> referencePointByCount = new HashMap<Integer, Integer>();
        Iterator<Object> iterator = this.referencePointsMatched.iterator();
        while (iterator.hasNext()) {
            int r = iterator.next();
            int count = 1;
            if (referencePointByCount.containsKey(r)) {
                count = (Integer)referencePointByCount.get(r);
                ++count;
            }
            referencePointByCount.put(r, count);
        }
        for (ValidatorProtos.ReferencePoint p : this.parsedReferencePoints.iterate()) {
            ArrayList<String> params;
            int refPointTagSpecId = this.parsedValidatorRules.getTagSpecIdByReferencePointTagSpecName(p.getTagSpecName());
            if (p.hasMandatory() && !referencePointByCount.containsKey(refPointTagSpecId)) {
                params = new ArrayList<String>();
                params.add(this.parsedValidatorRules.getReferencePointName(p));
                params.add(this.parsedReferencePoints.parentTagSpecName());
                context.addError(ValidatorProtos.ValidationError.Code.MANDATORY_REFERENCE_POINT_MISSING, this.getLineCol(), params, this.parsedReferencePoints.parentSpecUrl(), result);
            }
            if (!p.hasUnique() || !referencePointByCount.containsKey(refPointTagSpecId) || (Integer)referencePointByCount.get(refPointTagSpecId) == 1) continue;
            params = new ArrayList();
            params.add(this.parsedValidatorRules.getReferencePointName(p));
            params.add(this.parsedReferencePoints.parentTagSpecName());
            context.addError(ValidatorProtos.ValidationError.Code.DUPLICATE_REFERENCE_POINT, this.getLineCol(), params, this.parsedReferencePoints.parentSpecUrl(), result);
        }
    }

    public void cleanup() {
        this.lineCol = null;
        this.referencePointsMatched = null;
    }

    public Locator getLineCol() {
        return this.lineCol;
    }

    public void recordMatch(@Nonnull ParsedTagSpec parsedTagSpec) {
        this.referencePointsMatched.add(parsedTagSpec.id());
    }
}

