/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator;

import dev.amp.validator.CdataMatcher;
import dev.amp.validator.ChildTagMatcher;
import dev.amp.validator.Context;
import dev.amp.validator.DescendantConstraints;
import dev.amp.validator.ParsedHtmlTag;
import dev.amp.validator.ParsedTagSpec;
import dev.amp.validator.ParsedValidatorRules;
import dev.amp.validator.ReferencePointMatcher;
import dev.amp.validator.TagStackEntry;
import dev.amp.validator.ValidateTagResult;
import dev.amp.validator.ValidatorProtos;
import dev.amp.validator.exception.TagValidationException;
import dev.amp.validator.utils.TagSpecUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import org.xml.sax.Locator;

public class TagStack {
    @Nonnull
    private LinkedList<TagStackEntry> stack;
    @Nonnull
    private List<DescendantConstraints> allowedDescendantsList = new ArrayList<DescendantConstraints>();

    public TagStack() {
        this.stack = new LinkedList();
        this.stack.add(new TagStackEntry("$ROOT"));
        this.stack.add(new TagStackEntry("!DOCTYPE"));
    }

    public boolean countDocCssBytes() throws TagValidationException {
        ParsedTagSpec parentSpec = this.parentStackEntry().getTagSpec();
        return parentSpec != null && parentSpec.getSpec().hasCdata() && parentSpec.getSpec().getCdata().hasDocCssBytes();
    }

    public TagStackEntry parentStackEntry() throws TagValidationException {
        if (this.stack.size() < 1) {
            throw new TagValidationException("Parent of empty $ROOT tag requested.");
        }
        return this.back();
    }

    public TagStackEntry back() throws TagValidationException {
        if (this.stack.size() <= 0) {
            throw new TagValidationException("Exiting an empty tag stack.");
        }
        return this.stack.getLast();
    }

    public ReferencePointMatcher parentReferencePointMatcher() throws TagValidationException {
        return this.parentStackEntry().getReferencePointMatcher();
    }

    public void tellParentNoSiblingsAllowed(@Nonnull String tagName, @Nonnull Locator lineCol) throws TagValidationException {
        this.parentStackEntry().setOnlyChildTagName(tagName);
        this.parentStackEntry().setOnlyChildErrorLineCol(lineCol);
    }

    public Locator parentOnlyChildErrorLineCol() throws TagValidationException {
        return this.parentStackEntry().getOnlyChildErrorLineCol();
    }

    public String parentOnlyChildTagName() throws TagValidationException {
        return this.parentStackEntry().getOnlyChildTagName();
    }

    public boolean parentHasChildWithNoSiblingRule() throws TagValidationException {
        return this.parentOnlyChildTagName().length() > 0;
    }

    public Locator parentLastChildErrorLineCol() throws TagValidationException {
        return this.parentStackEntry().getLastChildErrorLineCol();
    }

    public List<DescendantConstraints> allowedDescendantsList() {
        return this.allowedDescendantsList;
    }

    public void tellParentImTheLastChild(@Nonnull String tagName, @Nonnull String url, @Nonnull Locator lineCol) throws TagValidationException {
        this.parentStackEntry().setLastChildTagName(tagName);
        this.parentStackEntry().setLastChildErrorLineCol(lineCol);
        this.parentStackEntry().setLastChildUrl(url);
    }

    public void matchChildTagName(@Nonnull ParsedHtmlTag encounteredTag, @Nonnull Context context, @Nonnull ValidatorProtos.ValidationResult.Builder result) throws TagValidationException {
        ChildTagMatcher matcher = this.parentStackEntry().getChildTagMatcher();
        if (matcher != null) {
            matcher.matchChildTagName(encounteredTag, context, result);
        }
    }

    public boolean isScriptTypeJsonChild() throws TagValidationException {
        return this.parentStackEntry().getTagName().equals("SCRIPT") && this.parentStackEntry().getTagSpec() != null && this.parentStackEntry().getTagSpec().isTypeJson();
    }

    public boolean hasAncestor(@Nonnull String ancestor) {
        for (int i = 1; i < this.stack.size(); ++i) {
            if (this.stack.get(i).getTagName().equals(ancestor)) {
                return true;
            }
            if (this.stack.get(i).getTagSpec() == null || !this.stack.get(i).getTagSpec().getSpec().getSpecName().equals(ancestor)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAncestorMarker(@Nonnull ValidatorProtos.AncestorMarker.Marker query) throws TagValidationException {
        if (query == ValidatorProtos.AncestorMarker.Marker.UNKNOWN) {
            throw new TagValidationException("Ancestor marker is unknown");
        }
        for (int i = 1; i < this.stack.size(); ++i) {
            ValidatorProtos.TagSpec spec;
            if (this.stack.get(i).getTagSpec() == null || !(spec = this.stack.get(i).getTagSpec().getSpec()).hasMarkDescendants()) continue;
            for (ValidatorProtos.AncestorMarker.Marker marker : spec.getMarkDescendants().getMarkerList()) {
                if (marker != query) continue;
                return true;
            }
        }
        return false;
    }

    private void enterTag(@Nonnull String tagName, @Nonnull ValidateTagResult referencePointResult, @Nonnull ValidateTagResult tagResult) {
        TagStackEntry stackEntry = new TagStackEntry(tagName);
        stackEntry.setReferencePoint(referencePointResult.getBestMatchTagSpec());
        stackEntry.setTagSpec(tagResult.getBestMatchTagSpec());
        this.stack.add(stackEntry);
    }

    public void exitTag(@Nonnull Context context, @Nonnull ValidatorProtos.ValidationResult.Builder result) throws TagValidationException {
        if (this.stack.size() <= 0) {
            throw new TagValidationException("Exiting an empty tag stack.");
        }
        this.unSetDescendantConstraintList();
        TagStackEntry topStackEntry = this.back();
        if (topStackEntry.getChildTagMatcher() != null) {
            topStackEntry.getChildTagMatcher().exitTag(context, result);
        }
        if (topStackEntry.getReferencePointMatcher() != null) {
            topStackEntry.getReferencePointMatcher().exitParentTag(context, result);
        }
        this.stack.removeLast();
    }

    public void updateStackEntryFromTagResult(@Nonnull ValidateTagResult result, @Nonnull ParsedValidatorRules parsedRules, @Nonnull Locator lineCol) throws TagValidationException {
        if (result.getBestMatchTagSpec() == null) {
            return;
        }
        ParsedTagSpec parsedTagSpec = result.getBestMatchTagSpec();
        this.setReferencePointMatcher(parsedTagSpec.referencePointMatcher(parsedRules, lineCol));
        if (result.getValidationResult().getStatus() == ValidatorProtos.ValidationResult.Status.PASS) {
            this.setChildTagMatcher(parsedTagSpec.childTagMatcher());
            this.setCdataMatcher(parsedTagSpec.cdataMatcher(lineCol));
            this.setDescendantConstraintList(parsedTagSpec, parsedRules);
        }
    }

    public void updateFromTagResults(@Nonnull ParsedHtmlTag encounteredTag, @Nonnull ValidateTagResult referencePointResult, @Nonnull ValidateTagResult tagResult, @Nonnull ParsedValidatorRules parsedRules, @Nonnull Locator lineCol) throws TagValidationException {
        this.parentStackEntry().incrementNumChildren();
        if (referencePointResult.getBestMatchTagSpec() != null) {
            if (this.parentReferencePointMatcher() == null) {
                throw new TagValidationException("Parent's reference point matcher is null");
            }
            this.parentReferencePointMatcher().recordMatch(referencePointResult.getBestMatchTagSpec());
        }
        if (tagResult.getValidationResult().getStatus() == ValidatorProtos.ValidationResult.Status.PASS) {
            ParsedTagSpec parsedTagSpec = tagResult.getBestMatchTagSpec();
            ValidatorProtos.TagSpec tagSpec = parsedTagSpec.getSpec();
            if (tagSpec.getSiblingsDisallowed()) {
                this.tellParentNoSiblingsAllowed(tagSpec.getTagName(), lineCol);
            }
            if (tagSpec.getMandatoryLastChild()) {
                this.tellParentImTheLastChild(TagSpecUtils.getTagSpecName(tagSpec), TagSpecUtils.getTagSpecUrl(tagSpec), lineCol);
            }
        }
        this.enterTag(encounteredTag.upperName(), referencePointResult, tagResult);
        this.updateStackEntryFromTagResult(referencePointResult, parsedRules, lineCol);
        this.updateStackEntryFromTagResult(tagResult, parsedRules, lineCol);
    }

    private void unSetDescendantConstraintList() throws TagValidationException {
        if (this.hasDescendantConstraintLists()) {
            this.allowedDescendantsList.remove(this.allowedDescendantsList.size() - 1);
            this.setHasDescendantConstraintLists(false);
        }
    }

    private boolean hasDescendantConstraintLists() throws TagValidationException {
        return this.back().getHasDescendantConstraintLists();
    }

    private void setHasDescendantConstraintLists(boolean value) throws TagValidationException {
        this.back().setHasDescendantConstraintLists(value);
    }

    public String parentTagSpecName() throws TagValidationException {
        if (this.parentStackEntry().getTagSpec() != null && this.parentStackEntry().getTagSpec().getSpec().hasSpecName()) {
            return this.parentStackEntry().getTagSpec().getSpec().getSpecName();
        }
        return this.parentStackEntry().getTagName();
    }

    public int parentChildCount() throws TagValidationException {
        return this.parentStackEntry().getNumChildren();
    }

    public void setReferencePointMatcher(ReferencePointMatcher matcher) throws TagValidationException {
        if (matcher != null) {
            this.back().setReferencePointMatcher(matcher);
        }
    }

    public void setChildTagMatcher(ChildTagMatcher matcher) throws TagValidationException {
        if (matcher != null) {
            this.back().setChildTagMatcher(matcher);
        }
    }

    public void setCdataMatcher(CdataMatcher matcher) throws TagValidationException {
        if (matcher != null) {
            this.back().setCdataMatcher(matcher);
        }
    }

    public CdataMatcher cdataMatcher() throws TagValidationException {
        return this.back().getCdataMatcher();
    }

    public String parentTagName() throws TagValidationException {
        return this.parentStackEntry().getTagName();
    }

    public String parentLastChildTagName() throws TagValidationException {
        return this.parentStackEntry().getLastChildTagName();
    }

    public String parentLastChildUrl() throws TagValidationException {
        return this.parentStackEntry().getLastChildUrl();
    }

    public boolean parentHasChildWithLastChildRule() throws TagValidationException {
        return this.parentLastChildTagName().length() > 0;
    }

    public void setDescendantConstraintList(@Nonnull ParsedTagSpec parsedTagSpec, @Nonnull ParsedValidatorRules parsedRules) throws TagValidationException {
        if (parsedTagSpec.getSpec().getDescendantTagList() == null || parsedTagSpec.getSpec().getDescendantTagList().equals("")) {
            return;
        }
        ArrayList<String> allowedDescendantsForThisTag = new ArrayList<String>();
        for (ValidatorProtos.DescendantTagList descendantTagList : parsedRules.getDescendantTagLists()) {
            if (!parsedTagSpec.getSpec().getDescendantTagList().equals(descendantTagList.getName())) continue;
            for (String tag : descendantTagList.getTagList()) {
                allowedDescendantsForThisTag.add(tag);
            }
        }
        String tagName = TagSpecUtils.getTagSpecName(parsedTagSpec.getSpec());
        if (tagName != null && !tagName.equals("")) {
            this.allowedDescendantsList.add(new DescendantConstraints(TagSpecUtils.getTagSpecName(parsedTagSpec.getSpec()), allowedDescendantsForThisTag));
            this.setHasDescendantConstraintLists(true);
        }
    }
}

