/*
 * Decompiled with CFR 0.152.
 */
package dev.array21.pluginstatlib;

import com.google.gson.Gson;
import dev.array21.pluginstatlib.StatPackage;
import dev.array21.pluginstatlib.StatResponse;
import java.io.IOException;
import java.util.Random;
import java.util.function.Consumer;
import nl.thedutchmc.httplib.Http;

public class PluginStat {
    private String uuid = null;
    private Consumer<String> setUuidFn = null;
    private Consumer<Object> logErrFn = null;
    private static final String SERVER = "https://plugin-stat.k8s.array21.dev/report";
    private static final int INTERVAL_MINUTES = 2;
    private static volatile boolean STOPPING = false;

    public void start() {
        Runnable r = new Runnable(){
            private final Http HTTP = new Http(true);
            private final Gson GSON = new Gson();

            @Override
            public void run() {
                while (!STOPPING) {
                    Http.ResponseObject response;
                    StatPackage statPackage = new StatPackage(PluginStat.this.uuid);
                    String statSerialized = this.GSON.toJson((Object)statPackage);
                    try {
                        response = this.HTTP.makeRequest(Http.RequestMethod.POST, PluginStat.SERVER, null, Http.MediaFormat.JSON, statSerialized, null);
                    }
                    catch (IOException e) {
                        PluginStat.this.logErrFn.accept("Failed to send metrics.");
                        this.sleep();
                        continue;
                    }
                    if (response.getResponseCode() != 200) {
                        PluginStat.this.logErrFn.accept("Failed to send metrics.");
                        this.sleep();
                        continue;
                    }
                    StatResponse r = (StatResponse)this.GSON.fromJson(response.getMessage(), StatResponse.class);
                    if (r.getStatus() == 409) {
                        PluginStat.this.uuid = r.getNewUuid();
                        PluginStat.this.setUuidFn.accept(r.getNewUuid());
                        continue;
                    }
                    this.sleep();
                }
            }

            private void sleep() {
                try {
                    Thread.sleep(120000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        Random ran = new Random();
        Thread t = new Thread(r, "PluginStatThread" + ran.nextInt(900000));
        t.start();
    }

    public static void disable() {
        STOPPING = true;
    }

    public static class PluginStatBuilder {
        private PluginStat pluginStat = new PluginStat();

        public static PluginStatBuilder createDefault() {
            return new PluginStatBuilder();
        }

        public PluginStatBuilder setUuid(String uuid) {
            this.pluginStat.uuid = uuid;
            return this;
        }

        public PluginStatBuilder setSetUuidFn(Consumer<String> fn) {
            this.pluginStat.setUuidFn = fn;
            return this;
        }

        public PluginStatBuilder setLogErrFn(Consumer<Object> fn) {
            this.pluginStat.logErrFn = fn;
            return this;
        }

        public PluginStat build() {
            if (this.pluginStat.uuid == null) {
                throw new IllegalStateException("UUID is unset");
            }
            if (this.pluginStat.logErrFn == null) {
                throw new IllegalStateException("logErrFn is unset");
            }
            if (this.pluginStat.setUuidFn == null) {
                throw new IllegalStateException("setUuidFn is unset");
            }
            return this.pluginStat;
        }
    }
}

