/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.mock;

import java.util.List;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import net.binis.codegen.tools.Holder;

public class CodeGenMatcher {
    static final ThreadLocal<Boolean> anyMock = ThreadLocal.withInitial(() -> false);

    private CodeGenMatcher() {
    }

    public static String anyString() {
        CodeGenMatcher.any(String.class);
        return "";
    }

    public static long anyLong() {
        CodeGenMatcher.any(Long.class);
        return 0L;
    }

    public static int anyInt() {
        CodeGenMatcher.any(Integer.class);
        return 0;
    }

    public static double anyDouble() {
        CodeGenMatcher.any(Double.class);
        return 0.0;
    }

    public static float anyFloat() {
        CodeGenMatcher.any(Float.class);
        return 0.0f;
    }

    public static <T> T any() {
        anyMock.set(true);
        return null;
    }

    public static <T> T any(Class<T> cls) {
        anyMock.set(true);
        return null;
    }

    public static <T> Supplier<T> orderedList(List<T> list) {
        Holder idx = Holder.of((Object)0);
        return () -> {
            Object result = list.get((Integer)idx.get());
            idx.set((Object)((Integer)idx.get() + 1));
            return result;
        };
    }

    public static LongSupplier times(int times) {
        return () -> Integer.toUnsignedLong(times);
    }

    public static LongSupplier never() {
        return () -> 0L;
    }

    public static LongSupplier once() {
        return () -> 1L;
    }

    public static LongSupplier twice() {
        return () -> 2L;
    }

    public static LongSupplier thrice() {
        return () -> 3L;
    }
}

