/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.mock;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import net.binis.codegen.mock.MockEntityManager;
import net.binis.codegen.mock.MockPersistenceOperation;
import net.binis.codegen.mock.MockedPersistenceContext;
import org.junit.Assert;

public class MockedPersistenceContextImpl
implements MockedPersistenceContext {
    private Object obj;
    private MockEntityManager em;
    private MockPersistenceOperation operation;

    @Override
    public MockedPersistenceContext called(LongSupplier times) {
        long expected = times.getAsLong();
        long actual = this.em.calls(this.operation, this.obj);
        Assert.assertEquals((long)expected, (long)actual);
        return this;
    }

    @Override
    public MockedPersistenceContext on(Consumer<Object> consumer) {
        this.em.onOperation(this.operation, this.obj, (op, ob) -> consumer.accept(ob));
        return this;
    }

    @Override
    public MockedPersistenceContext on(Runnable task) {
        this.em.onOperation(this.operation, this.obj, (op, ob) -> task.run());
        return this;
    }

    @Override
    public MockedPersistenceContext on(BiConsumer<MockPersistenceOperation, Object> consumer) {
        this.em.onOperation(this.operation, this.obj, consumer);
        return this;
    }

    MockedPersistenceContextImpl(Object obj, MockEntityManager em, MockPersistenceOperation operation) {
        this.obj = obj;
        this.em = em;
        this.operation = operation;
    }

    public static MockedPersistenceContextImplBuilder builder() {
        return new MockedPersistenceContextImplBuilder();
    }

    public static class MockedPersistenceContextImplBuilder {
        private Object obj;
        private MockEntityManager em;
        private MockPersistenceOperation operation;

        MockedPersistenceContextImplBuilder() {
        }

        public MockedPersistenceContextImplBuilder obj(Object obj) {
            this.obj = obj;
            return this;
        }

        public MockedPersistenceContextImplBuilder em(MockEntityManager em) {
            this.em = em;
            return this;
        }

        public MockedPersistenceContextImplBuilder operation(MockPersistenceOperation operation) {
            this.operation = operation;
            return this;
        }

        public MockedPersistenceContextImpl build() {
            return new MockedPersistenceContextImpl(this.obj, this.em, this.operation);
        }

        public String toString() {
            return "MockedPersistenceContextImpl.MockedPersistenceContextImplBuilder(obj=" + this.obj + ", em=" + this.em + ", operation=" + this.operation + ")";
        }
    }
}

