/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.factory;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.binis.codegen.annotation.Default;
import net.binis.codegen.factory.EmbeddedEnvelopFactory;
import net.binis.codegen.factory.EmbeddedObjectFactory;
import net.binis.codegen.factory.EnvelopFactory;
import net.binis.codegen.factory.EnvelopingObjectFactory;
import net.binis.codegen.factory.ObjectFactory;
import net.binis.codegen.tools.Reflection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeFactory {
    private static final Logger log = LoggerFactory.getLogger(CodeFactory.class);
    private static final Map<Class<?>, RegistryEntry> registry = new HashMap();
    private static final Map<Class<?>, IdRegistryEntry> idRegistry = new HashMap();
    private static EnvelopingObjectFactory envelopingFactory;

    private CodeFactory() {
    }

    public static <T> T create(Class<T> cls) {
        RegistryEntry entry = registry.get(cls);
        if (entry != null) {
            return (T)CodeFactory.internalEnvelop(entry.getImplFactory().create());
        }
        Class<?> parent = cls.getDeclaringClass();
        if (Objects.nonNull(parent)) {
            return (T)CodeFactory.defaultCreate(cls, parent);
        }
        return CodeFactory.defaultCreate(cls, cls);
    }

    public static <T> T create(Class<T> cls, String defaultClass) {
        RegistryEntry entry = registry.get(cls);
        Object obj = null;
        if (entry != null) {
            obj = entry.getImplFactory().create();
        } else {
            try {
                Reflection.initialize(defaultClass);
                obj = CodeFactory.internalCreate(cls);
            }
            catch (Exception e) {
                log.error("Can't find class: {}", (Object)defaultClass);
            }
        }
        return (T)CodeFactory.internalEnvelop(obj);
    }

    public static <M, T, P> M modify(P parent, T value) {
        RegistryEntry entry = registry.get(value.getClass());
        if (entry != null) {
            Object obj = entry.getModifierFactory().create(parent, value);
            if (Objects.isNull(envelopingFactory)) {
                return (M)obj;
            }
            return (M)envelopingFactory.envelop(obj);
        }
        return null;
    }

    public static Class<?> lookup(Class<?> intf) {
        RegistryEntry entry = registry.get(intf);
        if (entry != null) {
            if (entry.getImplClass() == null) {
                entry.setImplClass(entry.getImplFactory().create().getClass());
            }
            return entry.getImplClass();
        }
        return null;
    }

    public static IdDescription lookupId(Class<?> intf) {
        return idRegistry.get(intf);
    }

    public static void registerId(Class<?> cls, String fieldName, Class<?> fieldType) {
        idRegistry.computeIfAbsent(cls, k -> IdRegistryEntry.builder().name(fieldName).type(fieldType).build());
    }

    public static void registerType(Class<?> intf, ObjectFactory impl, EmbeddedObjectFactory modifier) {
        if (!registry.containsKey(intf)) {
            registry.put(intf, RegistryEntry.builder().implFactory(impl).modifierFactory(modifier).orgModifierFactory(modifier).build());
        }
    }

    public static void forceRegisterType(Class<?> intf, ObjectFactory impl, EmbeddedObjectFactory modifier) {
        registry.put(intf, RegistryEntry.builder().implFactory(impl).modifierFactory(modifier).orgModifierFactory(modifier).build());
    }

    public static void envelopType(Class<?> intf, EnvelopFactory impl, EmbeddedEnvelopFactory modifier) {
        EmbeddedObjectFactory embeddedFactory;
        RegistryEntry reg = registry.get(intf);
        ObjectFactory implFactory = reg.getImplFactory();
        reg.setImplFactory(() -> impl.envelop(implFactory));
        if (Objects.nonNull(reg.getModifierFactory()) && Objects.nonNull(embeddedFactory = reg.getModifierFactory()) && Objects.nonNull(modifier)) {
            reg.setModifierFactory((parent, value) -> modifier.envelop(embeddedFactory, parent, value));
        }
    }

    public static void clearEnvelopedType(Class<?> intf, EnvelopFactory impl, EmbeddedEnvelopFactory modifier) {
        EmbeddedObjectFactory embeddedFactory;
        RegistryEntry reg = registry.get(intf);
        ObjectFactory implFactory = reg.getImplFactory();
        reg.setImplFactory(() -> impl.envelop(implFactory));
        if (Objects.nonNull(reg.getModifierFactory()) && Objects.nonNull(embeddedFactory = reg.getModifierFactory()) && Objects.nonNull(modifier)) {
            reg.setModifierFactory(reg.orgModifierFactory);
        }
    }

    public static void envelopFactory(EnvelopingObjectFactory factory) {
        envelopingFactory = factory;
    }

    public static void clearEnvelopingFactory() {
        envelopingFactory = null;
    }

    public static ObjectFactory singleton(Object object) {
        return () -> object;
    }

    private static <T> T defaultCreate(Class<?> impl, Class<T> cls) {
        Default ann = cls.getDeclaredAnnotation(Default.class);
        if (Objects.nonNull(ann)) {
            return (T)CodeFactory.create(impl, ann.value());
        }
        return CodeFactory.internalEnvelop(null);
    }

    private static <T> T internalCreate(Class<T> cls) {
        RegistryEntry entry = registry.get(cls);
        if (entry != null) {
            return (T)entry.getImplFactory().create();
        }
        return null;
    }

    private static <T> T internalEnvelop(T instance) {
        if (Objects.nonNull(envelopingFactory)) {
            return (T)envelopingFactory.envelop(instance);
        }
        return instance;
    }

    private static class RegistryEntry {
        private Class<?> implClass;
        private ObjectFactory implFactory;
        private EmbeddedObjectFactory modifierFactory;
        private EmbeddedObjectFactory orgModifierFactory;

        RegistryEntry(Class<?> implClass, ObjectFactory implFactory, EmbeddedObjectFactory modifierFactory, EmbeddedObjectFactory orgModifierFactory) {
            this.implClass = implClass;
            this.implFactory = implFactory;
            this.modifierFactory = modifierFactory;
            this.orgModifierFactory = orgModifierFactory;
        }

        public static RegistryEntryBuilder builder() {
            return new RegistryEntryBuilder();
        }

        public Class<?> getImplClass() {
            return this.implClass;
        }

        public ObjectFactory getImplFactory() {
            return this.implFactory;
        }

        public EmbeddedObjectFactory getModifierFactory() {
            return this.modifierFactory;
        }

        public EmbeddedObjectFactory getOrgModifierFactory() {
            return this.orgModifierFactory;
        }

        public void setImplClass(Class<?> implClass) {
            this.implClass = implClass;
        }

        public void setImplFactory(ObjectFactory implFactory) {
            this.implFactory = implFactory;
        }

        public void setModifierFactory(EmbeddedObjectFactory modifierFactory) {
            this.modifierFactory = modifierFactory;
        }

        public void setOrgModifierFactory(EmbeddedObjectFactory orgModifierFactory) {
            this.orgModifierFactory = orgModifierFactory;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RegistryEntry)) {
                return false;
            }
            RegistryEntry other = (RegistryEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<?> this$implClass = this.getImplClass();
            Class<?> other$implClass = other.getImplClass();
            if (this$implClass == null ? other$implClass != null : !this$implClass.equals(other$implClass)) {
                return false;
            }
            ObjectFactory this$implFactory = this.getImplFactory();
            ObjectFactory other$implFactory = other.getImplFactory();
            if (this$implFactory == null ? other$implFactory != null : !this$implFactory.equals(other$implFactory)) {
                return false;
            }
            EmbeddedObjectFactory this$modifierFactory = this.getModifierFactory();
            EmbeddedObjectFactory other$modifierFactory = other.getModifierFactory();
            if (this$modifierFactory == null ? other$modifierFactory != null : !this$modifierFactory.equals(other$modifierFactory)) {
                return false;
            }
            EmbeddedObjectFactory this$orgModifierFactory = this.getOrgModifierFactory();
            EmbeddedObjectFactory other$orgModifierFactory = other.getOrgModifierFactory();
            return !(this$orgModifierFactory == null ? other$orgModifierFactory != null : !this$orgModifierFactory.equals(other$orgModifierFactory));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RegistryEntry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $implClass = this.getImplClass();
            result = result * 59 + ($implClass == null ? 43 : $implClass.hashCode());
            ObjectFactory $implFactory = this.getImplFactory();
            result = result * 59 + ($implFactory == null ? 43 : $implFactory.hashCode());
            EmbeddedObjectFactory $modifierFactory = this.getModifierFactory();
            result = result * 59 + ($modifierFactory == null ? 43 : $modifierFactory.hashCode());
            EmbeddedObjectFactory $orgModifierFactory = this.getOrgModifierFactory();
            result = result * 59 + ($orgModifierFactory == null ? 43 : $orgModifierFactory.hashCode());
            return result;
        }

        public String toString() {
            return "CodeFactory.RegistryEntry(implClass=" + this.getImplClass() + ", implFactory=" + this.getImplFactory() + ", modifierFactory=" + this.getModifierFactory() + ", orgModifierFactory=" + this.getOrgModifierFactory() + ")";
        }

        public static class RegistryEntryBuilder {
            private Class<?> implClass;
            private ObjectFactory implFactory;
            private EmbeddedObjectFactory modifierFactory;
            private EmbeddedObjectFactory orgModifierFactory;

            RegistryEntryBuilder() {
            }

            public RegistryEntryBuilder implClass(Class<?> implClass) {
                this.implClass = implClass;
                return this;
            }

            public RegistryEntryBuilder implFactory(ObjectFactory implFactory) {
                this.implFactory = implFactory;
                return this;
            }

            public RegistryEntryBuilder modifierFactory(EmbeddedObjectFactory modifierFactory) {
                this.modifierFactory = modifierFactory;
                return this;
            }

            public RegistryEntryBuilder orgModifierFactory(EmbeddedObjectFactory orgModifierFactory) {
                this.orgModifierFactory = orgModifierFactory;
                return this;
            }

            public RegistryEntry build() {
                return new RegistryEntry(this.implClass, this.implFactory, this.modifierFactory, this.orgModifierFactory);
            }

            public String toString() {
                return "CodeFactory.RegistryEntry.RegistryEntryBuilder(implClass=" + this.implClass + ", implFactory=" + this.implFactory + ", modifierFactory=" + this.modifierFactory + ", orgModifierFactory=" + this.orgModifierFactory + ")";
            }
        }
    }

    public static interface IdDescription {
        public String getName();

        public Class<?> getType();
    }

    private static class IdRegistryEntry
    implements IdDescription {
        private String name;
        private Class<?> type;

        IdRegistryEntry(String name, Class<?> type) {
            this.name = name;
            this.type = type;
        }

        public static IdRegistryEntryBuilder builder() {
            return new IdRegistryEntryBuilder();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setType(Class<?> type) {
            this.type = type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IdRegistryEntry)) {
                return false;
            }
            IdRegistryEntry other = (IdRegistryEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Class<?> this$type = this.getType();
            Class<?> other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof IdRegistryEntry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Class<?> $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public String toString() {
            return "CodeFactory.IdRegistryEntry(name=" + this.getName() + ", type=" + this.getType() + ")";
        }

        public static class IdRegistryEntryBuilder {
            private String name;
            private Class<?> type;

            IdRegistryEntryBuilder() {
            }

            public IdRegistryEntryBuilder name(String name) {
                this.name = name;
                return this;
            }

            public IdRegistryEntryBuilder type(Class<?> type) {
                this.type = type;
                return this;
            }

            public IdRegistryEntry build() {
                return new IdRegistryEntry(this.name, this.type);
            }

            public String toString() {
                return "CodeFactory.IdRegistryEntry.IdRegistryEntryBuilder(name=" + this.name + ", type=" + this.type + ")";
            }
        }
    }
}

