/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.async.executor.impl;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.binis.codegen.async.AsyncDispatcher;
import net.binis.codegen.async.executor.CodeGenCompletableFuture;
import net.binis.codegen.factory.CodeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseAsyncExecutorImpl<A, R> {
    private static final Logger log = LoggerFactory.getLogger(BaseAsyncExecutorImpl.class);
    protected String flow = "default";
    protected long delay;
    protected TimeUnit unit;

    public A flow(String flow) {
        this.flow = flow;
        return (A)this;
    }

    public A delay(long delay, TimeUnit unit) {
        this.delay = delay;
        this.unit = unit;
        return (A)this;
    }

    public A delay(Duration duration) {
        this.delay = duration.toMillis();
        this.unit = TimeUnit.MILLISECONDS;
        return (A)this;
    }

    protected CompletableFuture<R> internalExecute(Supplier<R> supplier) {
        Executor executor = CodeFactory.create(AsyncDispatcher.class).flow(this.flow);
        if (this.delay > 0L && Objects.nonNull((Object)this.unit)) {
            executor = CompletableFuture.delayedExecutor(this.delay, this.unit, executor);
        }
        return CodeGenCompletableFuture.newSupplyAsync(executor, supplier);
    }
}

