/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.factory;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.binis.codegen.annotation.Default;
import net.binis.codegen.exception.GenericCodeGenException;
import net.binis.codegen.factory.EmbeddedEnvelopFactory;
import net.binis.codegen.factory.EmbeddedObjectFactory;
import net.binis.codegen.factory.EnvelopFactory;
import net.binis.codegen.factory.EnvelopingObjectFactory;
import net.binis.codegen.factory.ObjectFactory;
import net.binis.codegen.factory.ProjectionInstantiation;
import net.binis.codegen.factory.ProjectionProvider;
import net.binis.codegen.objects.Pair;
import net.binis.codegen.objects.base.enumeration.CodeEnum;
import net.binis.codegen.objects.base.enumeration.CodeEnumImpl;
import net.binis.codegen.tools.Reflection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeFactory {
    private static final Logger log = LoggerFactory.getLogger(CodeFactory.class);
    private static final Map<Class<?>, RegistryEntry> registry = new HashMap();
    private static final Map<Class<?>, IdRegistryEntry> idRegistry = new HashMap();
    private static EnvelopingObjectFactory envelopingFactory;
    private static final Set<Class<?>> customProxyClassesRegistry;
    private static final List<Pair<Class<?>, ProjectionProvider>> customProxyClasses;
    private static final Map<Class<?>, Map<Class<?>, ProjectionInstantiation>> projectionsCache;
    private static ProjectionProvider projections;
    private static final Map<Class<?>, EnumEntry> enumRegistry;

    private CodeFactory() {
    }

    public static <T> T create(Class<T> cls) {
        Class<?> parent;
        RegistryEntry entry = registry.get(cls);
        if (entry != null) {
            return CodeFactory.internalEnvelop(entry.getImplFactory().create());
        }
        Object result = CodeFactory.defaultCreate(cls, cls);
        if (Objects.isNull(result) && Objects.nonNull(parent = cls.getDeclaringClass())) {
            result = CodeFactory.defaultCreate(cls, parent);
        }
        if (Objects.isNull(result)) {
            CodeFactory.registerType(cls, null, null);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> T create(Class<T> cls, String defaultClass) {
        RegistryEntry entry = registry.get(cls);
        T obj = null;
        if (entry != null) {
            if (entry.getImplFactory() == null) return null;
            obj = entry.getImplFactory().create();
            return CodeFactory.internalEnvelop(obj);
        }
        try {
            Reflection.initialize(defaultClass);
            obj = CodeFactory.internalCreate(cls);
            return CodeFactory.internalEnvelop(obj);
        }
        catch (Exception e) {
            log.error("Can't find class: {}", (Object)defaultClass);
        }
        return CodeFactory.internalEnvelop(obj);
    }

    public static <M, T, P> M modify(P parent, T value, Class cls) {
        RegistryEntry entry = registry.get(cls);
        if (entry != null) {
            Object obj = entry.getModifierFactory().create(parent, value);
            if (Objects.isNull(envelopingFactory)) {
                return (M)obj;
            }
            return (M)envelopingFactory.envelop(obj);
        }
        return null;
    }

    public static Class<?> lookup(Class<?> intf) {
        RegistryEntry entry = registry.get(intf);
        if (Objects.isNull(entry)) {
            CodeFactory.create(intf);
            entry = registry.get(intf);
        }
        if (entry != null) {
            if (entry.getImplClass() == null && entry.getImplFactory() != null) {
                entry.setImplClass(entry.getImplFactory().create().getClass());
            }
            return entry.getImplClass();
        }
        return null;
    }

    public static IdDescription lookupId(Class<?> intf) {
        return idRegistry.get(intf);
    }

    public static void registerId(Class<?> cls, String fieldName, Class<?> fieldType) {
        idRegistry.computeIfAbsent(cls, k -> IdRegistryEntry.builder().name(fieldName).type(fieldType).build());
    }

    public static void registerType(Class<?> intf, ObjectFactory impl, EmbeddedObjectFactory modifier) {
        RegistryEntry reg = registry.get(intf);
        if (Objects.isNull(reg) || Objects.isNull(reg.getImplClass())) {
            CodeFactory.forceRegisterType(intf, impl, modifier);
        }
    }

    public static void forceRegisterType(Class<?> intf, ObjectFactory impl, EmbeddedObjectFactory modifier) {
        registry.put(intf, RegistryEntry.builder().implFactory(impl).orgImplFactory(impl).modifierFactory(modifier).orgModifierFactory(modifier).build());
    }

    public static <T> void envelopType(Class<T> intf, EnvelopFactory<T> impl, EmbeddedEnvelopFactory modifier) {
        EmbeddedObjectFactory embeddedFactory;
        RegistryEntry reg = registry.get(intf);
        ObjectFactory implFactory = reg.getImplFactory();
        reg.setImplFactory(() -> impl.envelop(implFactory));
        if (Objects.nonNull(reg.getModifierFactory()) && Objects.nonNull(embeddedFactory = reg.getModifierFactory()) && Objects.nonNull(modifier)) {
            reg.setModifierFactory((parent, value) -> modifier.envelop(embeddedFactory, parent, value));
        }
    }

    public static void cleanEnvelopedType(Class<?> intf) {
        RegistryEntry reg = registry.get(intf);
        reg.setImplFactory(reg.orgImplFactory);
        reg.setModifierFactory(reg.orgModifierFactory);
    }

    public static void cleanAllEnvelopedTypes() {
        registry.forEach((c, reg) -> {
            reg.setImplFactory(reg.orgImplFactory);
            reg.setModifierFactory(reg.orgModifierFactory);
        });
    }

    public static void envelopFactory(EnvelopingObjectFactory factory) {
        envelopingFactory = factory;
    }

    public static void clearEnvelopingFactory() {
        envelopingFactory = null;
    }

    public static ObjectFactory singleton(Object object) {
        return () -> object;
    }

    public static void setProjectionProvider(ProjectionProvider provider) {
        projections = provider;
    }

    public static ProjectionProvider getProjectionProvider() {
        return projections;
    }

    public static void debug() {
        log.info("Registered classes: ");
        registry.forEach((key, value) -> log.info("- {}: {}", key, value));
    }

    public static <T> T projection(Object object, Class<T> projection) {
        if (Objects.nonNull(object)) {
            if (Objects.nonNull(projections)) {
                return (T)projectionsCache.computeIfAbsent(projection, k -> new HashMap()).computeIfAbsent(object.getClass(), k -> CodeFactory.checkForCustomClass(k).orElse(projections).create((Class<?>)k, projection)).create(object);
            }
            if (projection.isInstance(object)) {
                return projection.cast(object);
            }
            throw new GenericCodeGenException("Projections provider not present!");
        }
        return null;
    }

    public static Object projections(Object object, Class<?> ... projections) {
        if (Objects.nonNull(object) && projections.length > 0) {
            return CodeFactory.projection(object, projections[0]);
        }
        return object;
    }

    public static <T> T cast(Object object, Class<T> projection) {
        if (projection.isInstance(object)) {
            return projection.cast(object);
        }
        return CodeFactory.projection(object, projection);
    }

    public static void registerCustomProxyClass(Class<?> cls, ProjectionProvider provider) {
        customProxyClasses.add(Pair.of(cls, provider));
        customProxyClassesRegistry.add(cls);
    }

    public static boolean isCustomProxyClass(Class<?> cls) {
        return customProxyClassesRegistry.contains(cls);
    }

    public static <T extends CodeEnum> T initializeEnumValue(Class<T> cls, String name, int ordinal, Object ... params) {
        if (CodeEnum.class.isAssignableFrom(cls)) {
            CodeEnum inst;
            EnumEntry registry = enumRegistry.computeIfAbsent(cls, c -> EnumEntry.builder().initializer(CodeFactory.buildEnumInitializer(cls)).build());
            if (ordinal == Integer.MIN_VALUE) {
                ordinal = CodeFactory.generateUniqueOrdinal(registry);
            } else {
                inst = registry.ordinals.get(ordinal);
                if (Objects.nonNull(inst)) {
                    return (T)inst;
                }
                inst = registry.values.get(name);
                if (Objects.nonNull(inst)) {
                    return (T)inst;
                }
            }
            inst = registry.initializer.initialize(ordinal, name, params);
            registry.ordinals.put(ordinal, inst);
            registry.values.put(name, inst);
            registry.dirty = true;
            return (T)inst;
        }
        throw new GenericCodeGenException("Class " + cls.getCanonicalName() + " isn't enumeration class!");
    }

    private static int generateUniqueOrdinal(EnumEntry registry) {
        int result = -100;
        while (Objects.nonNull(registry.ordinals.get(result))) {
            --result;
        }
        return result;
    }

    public static <T extends CodeEnum> T initializeUnknownEnumValue(Class<T> cls, String name, int ordinal, Object ... params) {
        T result = CodeFactory.initializeEnumValue(cls, name, ordinal, params);
        ((CodeEnumImpl)result).setUnknown();
        return result;
    }

    public static <T extends CodeEnum> T enumValueOf(Class<T> cls, String name) {
        EnumEntry registry = enumRegistry.get(cls);
        if (Objects.nonNull(registry)) {
            return (T)registry.values.get(name);
        }
        return null;
    }

    public static <T extends CodeEnum> T enumValueOf(Class<T> cls, int ordinal) {
        EnumEntry registry = enumRegistry.get(cls);
        if (Objects.nonNull(registry)) {
            return (T)registry.ordinals.get(ordinal);
        }
        return null;
    }

    public static <T extends CodeEnum> T[] enumValues(Class<T> cls) {
        EnumEntry registry = enumRegistry.get(cls);
        if (Objects.nonNull(registry)) {
            if (registry.dirty) {
                registry.sorted = registry.values.values().stream().sorted(Comparator.comparing(CodeEnum::ordinal)).collect(Collectors.toList());
            }
            return (CodeEnum[])registry.sorted.toArray();
        }
        return (CodeEnum[])Array.newInstance(cls.getComponentType(), 0);
    }

    private static <T extends CodeEnum> EnumInitializer buildEnumInitializer(Class<T> cls) {
        Default a = cls.getAnnotation(Default.class);
        if (Objects.isNull(a)) {
            throw new GenericCodeGenException("Can't find implementation pointer for " + cls.getCanonicalName());
        }
        try {
            Class<?> c = Class.forName(a.value());
            Constructor<?> constructor = c.getDeclaredConstructors()[0];
            return (ordinal, name, params) -> {
                ArrayList<Object> list = new ArrayList<Object>(params.length + 2);
                list.add(ordinal);
                list.add(name);
                Collections.addAll(list, params);
                if (constructor.getParameterCount() > list.size()) {
                    Class<?>[] types = constructor.getParameterTypes();
                    for (int i = list.size(); i < constructor.getParameterCount(); ++i) {
                        list.add(CodeFactory.defaultValue(types[i]));
                    }
                }
                try {
                    return (CodeEnum)constructor.newInstance(list.toArray());
                }
                catch (Exception e) {
                    throw new GenericCodeGenException("Unable to initialize enum value!", e);
                }
            };
        }
        catch (ClassNotFoundException e) {
            throw new GenericCodeGenException("Can't find implementation class for " + cls.getCanonicalName());
        }
    }

    private static Object defaultValue(Class<?> type) {
        if (type.isPrimitive()) {
            if (Byte.TYPE.equals(type)) {
                return 0;
            }
            if (Short.TYPE.equals(type)) {
                return 0;
            }
            if (Integer.TYPE.equals(type)) {
                return 0;
            }
            if (Long.TYPE.equals(type)) {
                return 0L;
            }
            if (Float.TYPE.equals(type)) {
                return Float.valueOf(0.0f);
            }
            if (Double.TYPE.equals(type)) {
                return 0.0;
            }
            if (Character.TYPE.equals(type)) {
                return Character.valueOf('\u0000');
            }
            if (Boolean.TYPE.equals(type)) {
                return false;
            }
        }
        return null;
    }

    private static ProjectionProvider initProjectionProvider() {
        try {
            Class<?> cls = Class.forName("net.binis.codegen.projection.provider.CodeGenProjectionProvider");
            return (ProjectionProvider)cls.getDeclaredConstructors()[0].newInstance(new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Optional<ProjectionProvider> checkForCustomClass(Class<?> cls) {
        for (Pair<Class<?>, ProjectionProvider> c : customProxyClasses) {
            if (!c.getKey().isAssignableFrom(cls)) continue;
            return Optional.of(c.getValue());
        }
        return Optional.empty();
    }

    private static <T> T defaultCreate(Class<?> impl, Class<T> cls) {
        Default ann = cls.getDeclaredAnnotation(Default.class);
        if (Objects.nonNull(ann)) {
            return (T)CodeFactory.create(impl, ann.value());
        }
        return CodeFactory.internalEnvelop(null);
    }

    private static <T> T internalCreate(Class<T> cls) {
        RegistryEntry entry = registry.get(cls);
        if (entry != null) {
            return entry.getImplFactory().create();
        }
        return null;
    }

    private static <T> T internalEnvelop(T instance) {
        if (Objects.nonNull(envelopingFactory)) {
            return (T)envelopingFactory.envelop(instance);
        }
        return instance;
    }

    static {
        customProxyClassesRegistry = new HashSet();
        customProxyClasses = new ArrayList();
        projectionsCache = new HashMap();
        projections = CodeFactory.initProjectionProvider();
        enumRegistry = new HashMap();
    }

    private static class RegistryEntry {
        private Class<?> implClass;
        private ObjectFactory implFactory;
        private ObjectFactory orgImplFactory;
        private EmbeddedObjectFactory modifierFactory;
        private EmbeddedObjectFactory orgModifierFactory;

        RegistryEntry(Class<?> implClass, ObjectFactory implFactory, ObjectFactory orgImplFactory, EmbeddedObjectFactory modifierFactory, EmbeddedObjectFactory orgModifierFactory) {
            this.implClass = implClass;
            this.implFactory = implFactory;
            this.orgImplFactory = orgImplFactory;
            this.modifierFactory = modifierFactory;
            this.orgModifierFactory = orgModifierFactory;
        }

        public static RegistryEntryBuilder builder() {
            return new RegistryEntryBuilder();
        }

        public Class<?> getImplClass() {
            return this.implClass;
        }

        public ObjectFactory getImplFactory() {
            return this.implFactory;
        }

        public ObjectFactory getOrgImplFactory() {
            return this.orgImplFactory;
        }

        public EmbeddedObjectFactory getModifierFactory() {
            return this.modifierFactory;
        }

        public EmbeddedObjectFactory getOrgModifierFactory() {
            return this.orgModifierFactory;
        }

        public void setImplClass(Class<?> implClass) {
            this.implClass = implClass;
        }

        public void setImplFactory(ObjectFactory implFactory) {
            this.implFactory = implFactory;
        }

        public void setOrgImplFactory(ObjectFactory orgImplFactory) {
            this.orgImplFactory = orgImplFactory;
        }

        public void setModifierFactory(EmbeddedObjectFactory modifierFactory) {
            this.modifierFactory = modifierFactory;
        }

        public void setOrgModifierFactory(EmbeddedObjectFactory orgModifierFactory) {
            this.orgModifierFactory = orgModifierFactory;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RegistryEntry)) {
                return false;
            }
            RegistryEntry other = (RegistryEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<?> this$implClass = this.getImplClass();
            Class<?> other$implClass = other.getImplClass();
            if (this$implClass == null ? other$implClass != null : !this$implClass.equals(other$implClass)) {
                return false;
            }
            ObjectFactory this$implFactory = this.getImplFactory();
            ObjectFactory other$implFactory = other.getImplFactory();
            if (this$implFactory == null ? other$implFactory != null : !this$implFactory.equals(other$implFactory)) {
                return false;
            }
            ObjectFactory this$orgImplFactory = this.getOrgImplFactory();
            ObjectFactory other$orgImplFactory = other.getOrgImplFactory();
            if (this$orgImplFactory == null ? other$orgImplFactory != null : !this$orgImplFactory.equals(other$orgImplFactory)) {
                return false;
            }
            EmbeddedObjectFactory this$modifierFactory = this.getModifierFactory();
            EmbeddedObjectFactory other$modifierFactory = other.getModifierFactory();
            if (this$modifierFactory == null ? other$modifierFactory != null : !this$modifierFactory.equals(other$modifierFactory)) {
                return false;
            }
            EmbeddedObjectFactory this$orgModifierFactory = this.getOrgModifierFactory();
            EmbeddedObjectFactory other$orgModifierFactory = other.getOrgModifierFactory();
            return !(this$orgModifierFactory == null ? other$orgModifierFactory != null : !this$orgModifierFactory.equals(other$orgModifierFactory));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RegistryEntry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $implClass = this.getImplClass();
            result = result * 59 + ($implClass == null ? 43 : $implClass.hashCode());
            ObjectFactory $implFactory = this.getImplFactory();
            result = result * 59 + ($implFactory == null ? 43 : $implFactory.hashCode());
            ObjectFactory $orgImplFactory = this.getOrgImplFactory();
            result = result * 59 + ($orgImplFactory == null ? 43 : $orgImplFactory.hashCode());
            EmbeddedObjectFactory $modifierFactory = this.getModifierFactory();
            result = result * 59 + ($modifierFactory == null ? 43 : $modifierFactory.hashCode());
            EmbeddedObjectFactory $orgModifierFactory = this.getOrgModifierFactory();
            result = result * 59 + ($orgModifierFactory == null ? 43 : $orgModifierFactory.hashCode());
            return result;
        }

        public String toString() {
            return "CodeFactory.RegistryEntry(implClass=" + this.getImplClass() + ", implFactory=" + this.getImplFactory() + ", orgImplFactory=" + this.getOrgImplFactory() + ", modifierFactory=" + this.getModifierFactory() + ", orgModifierFactory=" + this.getOrgModifierFactory() + ")";
        }

        public static class RegistryEntryBuilder {
            private Class<?> implClass;
            private ObjectFactory implFactory;
            private ObjectFactory orgImplFactory;
            private EmbeddedObjectFactory modifierFactory;
            private EmbeddedObjectFactory orgModifierFactory;

            RegistryEntryBuilder() {
            }

            public RegistryEntryBuilder implClass(Class<?> implClass) {
                this.implClass = implClass;
                return this;
            }

            public RegistryEntryBuilder implFactory(ObjectFactory implFactory) {
                this.implFactory = implFactory;
                return this;
            }

            public RegistryEntryBuilder orgImplFactory(ObjectFactory orgImplFactory) {
                this.orgImplFactory = orgImplFactory;
                return this;
            }

            public RegistryEntryBuilder modifierFactory(EmbeddedObjectFactory modifierFactory) {
                this.modifierFactory = modifierFactory;
                return this;
            }

            public RegistryEntryBuilder orgModifierFactory(EmbeddedObjectFactory orgModifierFactory) {
                this.orgModifierFactory = orgModifierFactory;
                return this;
            }

            public RegistryEntry build() {
                return new RegistryEntry(this.implClass, this.implFactory, this.orgImplFactory, this.modifierFactory, this.orgModifierFactory);
            }

            public String toString() {
                return "CodeFactory.RegistryEntry.RegistryEntryBuilder(implClass=" + this.implClass + ", implFactory=" + this.implFactory + ", orgImplFactory=" + this.orgImplFactory + ", modifierFactory=" + this.modifierFactory + ", orgModifierFactory=" + this.orgModifierFactory + ")";
            }
        }
    }

    public static interface IdDescription {
        public String getName();

        public Class<?> getType();
    }

    private static class EnumEntry {
        private Map<Integer, CodeEnum> ordinals;
        private Map<String, CodeEnum> values;
        private boolean dirty;
        private List<CodeEnum> sorted;
        private EnumInitializer initializer;

        private static Map<Integer, CodeEnum> $default$ordinals() {
            return new HashMap<Integer, CodeEnum>();
        }

        private static Map<String, CodeEnum> $default$values() {
            return new HashMap<String, CodeEnum>();
        }

        private static boolean $default$dirty() {
            return true;
        }

        EnumEntry(Map<Integer, CodeEnum> ordinals, Map<String, CodeEnum> values, boolean dirty, List<CodeEnum> sorted, EnumInitializer initializer) {
            this.ordinals = ordinals;
            this.values = values;
            this.dirty = dirty;
            this.sorted = sorted;
            this.initializer = initializer;
        }

        public static EnumEntryBuilder builder() {
            return new EnumEntryBuilder();
        }

        public Map<Integer, CodeEnum> getOrdinals() {
            return this.ordinals;
        }

        public Map<String, CodeEnum> getValues() {
            return this.values;
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public List<CodeEnum> getSorted() {
            return this.sorted;
        }

        public EnumInitializer getInitializer() {
            return this.initializer;
        }

        public void setOrdinals(Map<Integer, CodeEnum> ordinals) {
            this.ordinals = ordinals;
        }

        public void setValues(Map<String, CodeEnum> values) {
            this.values = values;
        }

        public void setDirty(boolean dirty) {
            this.dirty = dirty;
        }

        public void setSorted(List<CodeEnum> sorted) {
            this.sorted = sorted;
        }

        public void setInitializer(EnumInitializer initializer) {
            this.initializer = initializer;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EnumEntry)) {
                return false;
            }
            EnumEntry other = (EnumEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isDirty() != other.isDirty()) {
                return false;
            }
            Map<Integer, CodeEnum> this$ordinals = this.getOrdinals();
            Map<Integer, CodeEnum> other$ordinals = other.getOrdinals();
            if (this$ordinals == null ? other$ordinals != null : !((Object)this$ordinals).equals(other$ordinals)) {
                return false;
            }
            Map<String, CodeEnum> this$values = this.getValues();
            Map<String, CodeEnum> other$values = other.getValues();
            if (this$values == null ? other$values != null : !((Object)this$values).equals(other$values)) {
                return false;
            }
            List<CodeEnum> this$sorted = this.getSorted();
            List<CodeEnum> other$sorted = other.getSorted();
            if (this$sorted == null ? other$sorted != null : !((Object)this$sorted).equals(other$sorted)) {
                return false;
            }
            EnumInitializer this$initializer = this.getInitializer();
            EnumInitializer other$initializer = other.getInitializer();
            return !(this$initializer == null ? other$initializer != null : !this$initializer.equals(other$initializer));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EnumEntry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isDirty() ? 79 : 97);
            Map<Integer, CodeEnum> $ordinals = this.getOrdinals();
            result = result * 59 + ($ordinals == null ? 43 : ((Object)$ordinals).hashCode());
            Map<String, CodeEnum> $values = this.getValues();
            result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
            List<CodeEnum> $sorted = this.getSorted();
            result = result * 59 + ($sorted == null ? 43 : ((Object)$sorted).hashCode());
            EnumInitializer $initializer = this.getInitializer();
            result = result * 59 + ($initializer == null ? 43 : $initializer.hashCode());
            return result;
        }

        public String toString() {
            return "CodeFactory.EnumEntry(ordinals=" + this.getOrdinals() + ", values=" + this.getValues() + ", dirty=" + this.isDirty() + ", sorted=" + this.getSorted() + ", initializer=" + this.getInitializer() + ")";
        }

        public static class EnumEntryBuilder {
            private boolean ordinals$set;
            private Map<Integer, CodeEnum> ordinals$value;
            private boolean values$set;
            private Map<String, CodeEnum> values$value;
            private boolean dirty$set;
            private boolean dirty$value;
            private List<CodeEnum> sorted;
            private EnumInitializer initializer;

            EnumEntryBuilder() {
            }

            public EnumEntryBuilder ordinals(Map<Integer, CodeEnum> ordinals) {
                this.ordinals$value = ordinals;
                this.ordinals$set = true;
                return this;
            }

            public EnumEntryBuilder values(Map<String, CodeEnum> values) {
                this.values$value = values;
                this.values$set = true;
                return this;
            }

            public EnumEntryBuilder dirty(boolean dirty) {
                this.dirty$value = dirty;
                this.dirty$set = true;
                return this;
            }

            public EnumEntryBuilder sorted(List<CodeEnum> sorted) {
                this.sorted = sorted;
                return this;
            }

            public EnumEntryBuilder initializer(EnumInitializer initializer) {
                this.initializer = initializer;
                return this;
            }

            public EnumEntry build() {
                Map<Integer, CodeEnum> ordinals$value = this.ordinals$value;
                if (!this.ordinals$set) {
                    ordinals$value = EnumEntry.$default$ordinals();
                }
                Map<String, CodeEnum> values$value = this.values$value;
                if (!this.values$set) {
                    values$value = EnumEntry.$default$values();
                }
                boolean dirty$value = this.dirty$value;
                if (!this.dirty$set) {
                    dirty$value = EnumEntry.$default$dirty();
                }
                return new EnumEntry(ordinals$value, values$value, dirty$value, this.sorted, this.initializer);
            }

            public String toString() {
                return "CodeFactory.EnumEntry.EnumEntryBuilder(ordinals$value=" + this.ordinals$value + ", values$value=" + this.values$value + ", dirty$value=" + this.dirty$value + ", sorted=" + this.sorted + ", initializer=" + this.initializer + ")";
            }
        }
    }

    @FunctionalInterface
    private static interface EnumInitializer {
        public CodeEnum initialize(int var1, String var2, Object ... var3);
    }

    private static class IdRegistryEntry
    implements IdDescription {
        private String name;
        private Class<?> type;

        IdRegistryEntry(String name, Class<?> type) {
            this.name = name;
            this.type = type;
        }

        public static IdRegistryEntryBuilder builder() {
            return new IdRegistryEntryBuilder();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setType(Class<?> type) {
            this.type = type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IdRegistryEntry)) {
                return false;
            }
            IdRegistryEntry other = (IdRegistryEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Class<?> this$type = this.getType();
            Class<?> other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof IdRegistryEntry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Class<?> $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public String toString() {
            return "CodeFactory.IdRegistryEntry(name=" + this.getName() + ", type=" + this.getType() + ")";
        }

        public static class IdRegistryEntryBuilder {
            private String name;
            private Class<?> type;

            IdRegistryEntryBuilder() {
            }

            public IdRegistryEntryBuilder name(String name) {
                this.name = name;
                return this;
            }

            public IdRegistryEntryBuilder type(Class<?> type) {
                this.type = type;
                return this;
            }

            public IdRegistryEntry build() {
                return new IdRegistryEntry(this.name, this.type);
            }

            public String toString() {
                return "CodeFactory.IdRegistryEntry.IdRegistryEntryBuilder(name=" + this.name + ", type=" + this.type + ")";
            }
        }
    }
}

