/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.validation.flow.impl.base;

import java.util.Objects;
import java.util.function.Consumer;
import net.binis.codegen.exception.ValidationException;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.tools.Reflection;
import net.binis.codegen.validation.Executor;
import net.binis.codegen.validation.Sanitizer;
import net.binis.codegen.validation.Validator;
import net.binis.codegen.validation.flow.Validation;
import net.binis.codegen.validation.flow.ValidationStart;

public abstract class BaseValidationFlow
implements Validation,
ValidationStart {
    protected Object value;
    protected String field;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Validation validate(Class intf, String message, Object ... params) {
        Class entry = CodeFactory.lookup((Class)intf);
        if (Objects.isNull(entry) && !intf.isInterface()) {
            Reflection.instantiate((Class)intf);
            entry = CodeFactory.lookup((Class)intf);
        }
        if (!Objects.nonNull(entry)) throw new ValidationException(intf.getCanonicalName() + " is not registered!");
        Object obj = CodeFactory.create((Class)intf);
        if (!(obj instanceof Validator)) throw new ValidationException(intf.getCanonicalName() + " is not validator!");
        if (((Validator)obj).validate(this.value, params)) return this;
        this.handleValidationError(this.field, this.value, message, params);
        return this;
    }

    public Validation sanitize(Class intf, Object ... params) {
        Object obj;
        Class entry = CodeFactory.lookup((Class)intf);
        if (Objects.isNull(entry) && !intf.isInterface()) {
            Reflection.instantiate((Class)intf);
            entry = CodeFactory.lookup((Class)intf);
        }
        if (Objects.nonNull(entry)) {
            obj = CodeFactory.create((Class)intf);
            if (!(obj instanceof Sanitizer)) {
                throw new ValidationException(intf.getCanonicalName() + " is not sanitizer!");
            }
        } else {
            throw new ValidationException(intf.getCanonicalName() + " is not registered!");
        }
        this.value = ((Sanitizer)obj).sanitize(this.value, params);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Validation execute(Class intf, String message, Object ... params) {
        Class entry = CodeFactory.lookup((Class)intf);
        if (Objects.isNull(entry) && !intf.isInterface()) {
            Reflection.instantiate((Class)intf);
            entry = CodeFactory.lookup((Class)intf);
        }
        if (!Objects.nonNull(entry)) throw new ValidationException(intf.getCanonicalName() + " is not registered!");
        Object obj = CodeFactory.create((Class)intf);
        if (!(obj instanceof Executor)) throw new ValidationException(intf.getCanonicalName() + " is not executor!");
        if (((Executor)obj).execute(this.value, params)) return this;
        this.handleValidationError(this.field, this.value, message, params);
        return this;
    }

    @Override
    public <T> Validation<T> start(String field, T value) {
        this.field = field;
        this.value = value;
        return this;
    }

    public void perform(Consumer operation) {
        operation.accept(this.value);
    }

    protected abstract void handleValidationError(String var1, Object var2, String var3, Object ... var4);
}

