/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.validation.sanitizer;

import java.math.BigDecimal;
import java.util.Objects;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.validation.Sanitizer;

public class RangeSanitizer
implements Sanitizer {
    private static final RangeSanitizer instance = new RangeSanitizer();

    public RangeSanitizer() {
        CodeFactory.registerType(RangeSanitizer.class, () -> instance, null);
    }

    public <T> T sanitize(T value, Object ... params) {
        if (Objects.nonNull(value) && value instanceof Number && params.length > 1) {
            BigDecimal max;
            BigDecimal val = BigDecimal.valueOf(((Number)value).doubleValue());
            BigDecimal min = params[0] instanceof String ? BigDecimal.valueOf(Double.parseDouble((String)params[0])) : BigDecimal.valueOf(((Number)params[0]).doubleValue());
            BigDecimal bigDecimal = max = params[1] instanceof String ? BigDecimal.valueOf(Double.parseDouble((String)params[1])) : BigDecimal.valueOf(((Number)params[1]).doubleValue());
            if (val.compareTo(min) < 0) {
                return this.convert(value, min);
            }
            if (val.compareTo(max) > 0) {
                return this.convert(value, max);
            }
        }
        return value;
    }

    private <T> T convert(T value, BigDecimal val) {
        if (value instanceof Integer) {
            return (T)Integer.valueOf(val.intValue());
        }
        if (value instanceof Long) {
            return (T)Long.valueOf(val.longValue());
        }
        if (value instanceof Double) {
            return (T)Double.valueOf(val.doubleValue());
        }
        if (value instanceof Float) {
            return (T)Float.valueOf(val.floatValue());
        }
        if (value instanceof Byte) {
            return (T)Byte.valueOf(val.byteValue());
        }
        if (value instanceof Short) {
            return (T)Short.valueOf(val.shortValue());
        }
        return value;
    }
}

