/*
 * Decompiled with CFR 0.152.
 */
package net.binis.codegen.validation.flow.impl.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.binis.codegen.exception.ValidationException;
import net.binis.codegen.exception.ValidationFormException;
import net.binis.codegen.factory.CodeFactory;
import net.binis.codegen.objects.Pair;
import net.binis.codegen.tools.Reflection;
import net.binis.codegen.validation.Executor;
import net.binis.codegen.validation.Sanitizer;
import net.binis.codegen.validation.Validator;
import net.binis.codegen.validation.ValidatorWithMessages;
import net.binis.codegen.validation.flow.Validation;
import net.binis.codegen.validation.flow.ValidationStart;

public abstract class BaseValidationFlow
implements Validation,
ValidationStart {
    protected Object value;
    protected String field;
    protected List<Pair<String, String>> errors;
    protected Class<?> cls;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Validation validate(Class intf, String message, Object ... params) {
        Class entry = CodeFactory.lookup((Class)intf);
        if (Objects.isNull(entry) && !intf.isInterface()) {
            Reflection.instantiate((Class)intf);
            entry = CodeFactory.lookup((Class)intf);
        }
        if (!Objects.nonNull(entry)) throw new ValidationException(this.cls, intf.getSimpleName(), intf.getCanonicalName() + " is not registered!");
        Object obj = CodeFactory.create((Class)intf);
        if (!(obj instanceof Validator)) throw new ValidationException(this.cls, intf.getSimpleName(), intf.getCanonicalName() + " is not validator!");
        if (((Validator)obj).validate(this.value, params)) return this;
        this.handleValidationError(this.field, this.value, message, params);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Validation validateWithMessages(Class intf, String[] messages, Object ... params) {
        Class entry = CodeFactory.lookup((Class)intf);
        if (Objects.isNull(entry) && !intf.isInterface()) {
            Reflection.instantiate((Class)intf);
            entry = CodeFactory.lookup((Class)intf);
        }
        if (!Objects.nonNull(entry)) throw new ValidationException(this.cls, intf.getSimpleName(), intf.getCanonicalName() + " is not registered!");
        Object obj = CodeFactory.create((Class)intf);
        if (!(obj instanceof ValidatorWithMessages)) throw new ValidationException(this.cls, intf.getSimpleName(), intf.getCanonicalName() + " is not validator!");
        ValidatorWithMessages validator = (ValidatorWithMessages)obj;
        ValidatorWithMessages.ValidationResult result = validator.validate(this.value, params);
        if (result.result()) return this;
        this.handleValidationError(this.field, this.value, messages[result.error()], params);
        return this;
    }

    public Validation sanitize(Class intf, Object ... params) {
        Object obj;
        Class entry = CodeFactory.lookup((Class)intf);
        if (Objects.isNull(entry) && !intf.isInterface()) {
            Reflection.instantiate((Class)intf);
            entry = CodeFactory.lookup((Class)intf);
        }
        if (Objects.nonNull(entry)) {
            obj = CodeFactory.create((Class)intf);
            if (!(obj instanceof Sanitizer)) {
                throw new ValidationException(this.cls, intf.getSimpleName(), intf.getCanonicalName() + " is not sanitizer!");
            }
        } else {
            throw new ValidationException(this.cls, intf.getSimpleName(), intf.getCanonicalName() + " is not registered!");
        }
        this.value = ((Sanitizer)obj).sanitize(this.value, params);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Validation execute(Class intf, String message, Object ... params) {
        Class entry = CodeFactory.lookup((Class)intf);
        if (Objects.isNull(entry) && !intf.isInterface()) {
            Reflection.instantiate((Class)intf);
            entry = CodeFactory.lookup((Class)intf);
        }
        if (!Objects.nonNull(entry)) throw new ValidationException(this.cls, intf.getSimpleName(), intf.getCanonicalName() + " is not registered!");
        Object obj = CodeFactory.create((Class)intf);
        if (!(obj instanceof Executor)) throw new ValidationException(this.cls, intf.getSimpleName(), intf.getCanonicalName() + " is not executor!");
        if (((Executor)obj).execute(this.value, params)) return this;
        this.handleValidationError(this.field, this.value, message, params);
        return this;
    }

    public Validation errors(List list) {
        this.errors = list;
        return this;
    }

    public Validation cls(Class cls) {
        this.cls = cls;
        return this;
    }

    @Override
    public <T> Validation<T> start(String field, T value) {
        this.field = field;
        this.value = value;
        return this;
    }

    public void perform(Consumer operation) {
        operation.accept(this.value);
    }

    public void form(Class cls, Consumer ... operations) {
        HashMap<String, List<String>> all = new HashMap<String, List<String>>();
        for (Consumer op : operations) {
            ArrayList<Pair> err;
            block5: {
                err = new ArrayList<Pair>();
                try {
                    op.accept(err);
                }
                catch (ValidationException ex) {
                    this.append(all, ex.getField(), ex.getMessage());
                }
                catch (Exception e2) {
                    if (!err.isEmpty()) break block5;
                    this.append(all, "<unknown>", e2.getMessage());
                }
            }
            err.forEach(e -> this.append(all, (String)e.getKey(), (String)e.getValue()));
        }
        if (!all.isEmpty()) {
            throw new ValidationFormException(cls, all);
        }
    }

    private void append(Map<String, List<String>> all, String field, String message) {
        List list = all.computeIfAbsent(field, k -> new ArrayList());
        list.add(message);
    }

    protected abstract void handleValidationError(String var1, Object var2, String var3, Object ... var4);
}

